---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-スタックトレースエクスプローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorer.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorer.xaml.cs`（コードビハインド）
- E-03: `src/VisualStudio/Core/Def/StackTraceExplorer/StackTraceExplorerViewModel.cs`（ViewModel）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クラス名はStackTraceExplorer | E-01 行1 x:Class定義 | ○ |
| C-02 | ListViewでフレーム一覧表示 | E-01 行25-83 ListView | ○ |
| C-03 | ItemsSource="{Binding Frames}" | E-01 行26 | ○ |
| C-04 | SelectedItem="{Binding Selection}" | E-01 行28 | ○ |
| C-05 | DataTemplateでBindableTextBlock使用 | E-01 行79-81 | ○ |
| C-06 | CommandBindingでPaste処理 | E-01 行16-17, 20-21 | ○ |
| C-07 | ガイダンスTextBlock存在 | E-01 行84-88 | ○ |
| C-08 | InstructionTextバインディング | E-01 行84 Text="{Binding InstructionText}" | ○ |
| C-09 | IsInstructionTextVisibleで表示制御 | E-01 行84 Visibility Binding | ○ |
| C-10 | DataObject.AddPastingHandler登録 | E-02 行23 | ○ |
| C-11 | OnPasteでクリップボード取得 | E-02 行32-36 | ○ |
| C-12 | ListViewItem_MouseDoubleClickでナビゲート | E-02 行38-44 | ○ |
| C-13 | OnClearでFrames.Clear | E-02 行46-48, E-03 行40-43 | ○ |
| C-14 | ViewModelでFrames管理 | E-03 行19 ObservableCollection | ○ |
| C-15 | OnPaste_CallOnUIThread実装 | E-03 行61-79 | ○ |
| C-16 | SetStackTraceResultAsync実装 | E-03 行81-95 | ○ |
| C-17 | IsListVisible計算プロパティ | E-03 行35 Frames.Count > 0 | ○ |
| C-18 | 機能No.85「スタックトレース探索」に関連 | E-05 画面No18の行 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張について根拠を確認）

## 5) リスクフラグ（レビュー観点）
- 0: UI構造・リスト表示
- 0: ペースト処理
- 1: スタックトレース解析の精度（様々な形式への対応確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] 様々な形式のスタックトレースが正しく解析されることを確認
- [ ] ダブルクリックでソースコードにナビゲートすることを確認
- [ ] クリア操作でフレーム一覧がクリアされることを確認
- [ ] ガイダンスメッセージがフレーム一覧が空の時に表示されることを確認
