---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-パラメータ追加ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml` (行1-163)
- E-02: `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialog.xaml.cs` (行1-88)
- E-03: `src/VisualStudio/Core/Def/ChangeSignature/AddParameterDialogViewModel.cs` (行1-268)
- E-04: `src/VisualStudio/Core/Def/ChangeSignature/ChangeSignatureDialog.xaml.cs` (行157-183)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (行3)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行4)
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` (行44-45)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シグネチャ変更ダイアログからAddボタンで呼び出される | E-04 行157-161 | ○ |
| C-02 | 型名、パラメータ名、種別、呼び出し元値を入力する | E-01 行34-139 | ○ |
| C-03 | 3つのGroupBoxで構成（Parameter information, Parameter kind, Value to inject） | E-01 行34, 66, 93 | ○ |
| C-04 | 型入力時にリアルタイムバリデーション | E-03 行105-115, 177-232 | ○ |
| C-05 | 4種類のアイコンで型解決状態を表示 | E-01 行51-54, E-03 行27-31 | ○ |
| C-06 | 必須/オプションのラジオボタン選択 | E-01 行68-90 | ○ |
| C-07 | オプション選択時のみデフォルト値入力可能 | E-01 行84-89 | ○ |
| C-08 | 5種類の呼び出し元値挿入方法 | E-01 行105-137 | ○ |
| C-09 | Value選択時に名前付き引数チェックボックス | E-01 行113-118 | ○ |
| C-10 | Omitはオプションパラメータのみ有効 | E-01 行135 | ○ |
| C-11 | System.Voidはパラメータ型として無効 | E-03 行127-130 | ○ |
| C-12 | 型名が必須 | E-03 行121-125 | ○ |
| C-13 | パラメータ名が必須 | E-03 行121-125 | ○ |
| C-14 | 呼び出し元値が必須（Value選択時） | E-03 行145-149 | ○ |
| C-15 | デフォルト値が必須（オプション選択時） | E-03 行151-155 | ○ |
| C-16 | パラメータ名の識別子検証 | E-03 行263-267 | ○ |
| C-17 | SizeToContent="Height" | E-01 行13 | ○ |
| C-18 | 最小幅600px | E-01 行12 | ○ |
| C-19 | リサイズ可能 | E-01 行16 | ○ |
| C-20 | WPFバグ回避のためOnClosedでDataContext=null | E-02 行51-57 | ○ |
| C-21 | 型解決はSemanticModel.GetSpeculativeTypeInfoを使用 | E-03 行197 | ○ |
| C-22 | 画面遷移図との整合性（CSD → APD） | E-07 行44-45 | ○ |
| C-23 | 機能マッピングとの整合性 | E-06 | ○ |
| C-24 | ダイアログ読み込み完了時に型入力欄にフォーカス | E-02 行45-49 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全項目に明確な根拠あり
- 0: 低リスク - バリデーションロジックは詳細に文書化

## 6) レビュアーチェックリスト（最小）

- [ ] 5種類の呼び出し元値挿入方法の説明は正確か
- [ ] バリデーションメッセージの一覧は網羅的か
- [ ] 画面遷移図との整合性を確認したか
