---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-プレビューペイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/PreviewPane/PreviewPane.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Def/PreviewPane/PreviewPane.xaml.cs`（コードビハインド）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クラス名はPreviewPane | E-01 行1 x:Class定義 | ○ |
| C-02 | UserControl, IDisposable, IOleCommandTarget実装 | E-02 行28 クラス定義 | ○ |
| C-03 | DockPanelレイアウト | E-01 行96 DockPanel | ○ |
| C-04 | HeaderStackPanelが存在 | E-01 行97 StackPanel Name="HeaderStackPanel" | ○ |
| C-05 | ExpanderToggleButtonが存在 | E-01 行106-108 ToggleButton Name="ExpanderToggleButton" | ○ |
| C-06 | SeverityIconBorderが存在 | E-01 行109 Border Name="SeverityIconBorder" | ○ |
| C-07 | IdHyperlinkが存在 | E-01 行111-114 Hyperlink Name="IdHyperlink" | ○ |
| C-08 | TitleRunが存在 | E-01 行116 Run Name="TitleRun" | ○ |
| C-09 | DescriptionDockPanelが存在 | E-01 行121 DockPanel Name="DescriptionDockPanel" | ○ |
| C-10 | LearnMoreHyperlinkが存在 | E-01 行134-137 Hyperlink Name="LearnMoreHyperlink" | ○ |
| C-11 | PreviewDockPanelが存在 | E-01 行142 DockPanel Name="PreviewDockPanel" | ○ |
| C-12 | PreviewScrollViewerが存在 | E-01 行143-146 ScrollViewer Name="PreviewScrollViewer" | ○ |
| C-13 | OptionsButtonが存在 | E-01 行148 Button x:Name="OptionsButton" | ○ |
| C-14 | AutomationNameプロパティ定義 | E-02 行132 AutomationName | ○ |
| C-15 | InitializePreviewElement実装 | E-02 行134-154 メソッド定義 | ○ |
| C-16 | CreatePreviewElement実装（最大3個制限） | E-02 行156-222 MaxItems = 3 | ○ |
| C-17 | GetPreviewElement実装 | E-02 行224-253 メソッド定義 | ○ |
| C-18 | DifferenceViewerPreviewの処理 | E-02 行226-238 | ○ |
| C-19 | ExpanderToggleButton_CheckedChanged実装 | E-02 行394-423 イベントハンドラ | ○ |
| C-20 | LearnMoreHyperlink_RequestNavigate実装 | E-02 行376-392 イベントハンドラ | ○ |
| C-21 | OptionsButton_Click実装 | E-02 行425-435 イベントハンドラ | ○ |
| C-22 | 機能No.22「コードリファクタリング」に関連 | E-04 画面No20の行 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張について根拠を確認）

## 5) リスクフラグ（レビュー観点）
- 0: UI構造・レイアウト
- 0: 展開/折りたたみ処理
- 0: ハイパーリンクナビゲーション
- 1: 差分ビューアのリソース管理（Dispose確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] 診断ID、タイトル、重大度アイコンが正しく表示されることを確認
- [ ] 展開ボタンで説明が表示/非表示になることを確認
- [ ] ハイパーリンクでブラウザが起動することを確認
- [ ] 差分プレビューが正しく表示されることを確認
- [ ] ペインを閉じた際にリソースが解放されることを確認
