---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：21-リネームフライアウト画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **C-25 メニューからのアクセス経路**：Visual Studio側のメニュー構成の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml` (行1-147)
- E-02: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml.cs` (行1-263)
- E-03: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyoutViewModel.cs` (行1-443)
- E-04: `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameViewModel.cs` (行1-371)
- E-05: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml` (行1-10)
- E-06: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml.cs` (行1-72)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行27-28)
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md` (行59-79)
- E-09: `docs/code-to-docs/画面一覧/画面一覧.csv` (行22)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | F2キーでリネームフライアウトが表示される | E-08 行74-78 | ○ |
| C-02 | フライアウトはInlineRenameAdornmentを継承 | E-02 行23 | ○ |
| C-03 | ViewModelはINotifyPropertyChangedを実装 | E-03 行32 | ○ |
| C-04 | IdentifierTextプロパティで新しい名前を管理 | E-03 行77-91 | ○ |
| C-05 | RenameOverloadsFlagオプションが存在 | E-03 行185-193, E-01 行122-124 | ○ |
| C-06 | RenameInCommentsFlagオプションが存在 | E-03 行145-153, E-01 行125-126 | ○ |
| C-07 | RenameInStringsFlagオプションが存在 | E-03 行155-163, E-01 行127-128 | ○ |
| C-08 | RenameFileFlagオプションが存在 | E-03 行165-173, E-01 行129-135 | ○ |
| C-09 | Enterキーでリネームが確定される | E-02 行181-185 | ○ |
| C-10 | Escapeキーでリネームがキャンセルされる | E-02 行187-189 | ○ |
| C-11 | Shift+Enterでプレビュー表示 | E-02 行183 | ○ |
| C-12 | Ctrl+Spaceでスマートリネーム候補取得 | E-02 行192-203 | ○ |
| C-13 | SmartRenameViewModelがCopilot連携を管理 | E-04 行28-31 | ○ |
| C-14 | SuggestedNamesがObservableCollectionで管理 | E-04 行56 | ○ |
| C-15 | StatusTextでエラー・警告を表示 | E-03 行114-119, E-01 行110 | ○ |
| C-16 | StatusImageMonikerでアイコンを表示 | E-03 行138-143, E-01 行109 | ○ |
| C-17 | SearchTextで参照数を表示 | E-03 行107-112, E-01 行113-119 | ○ |
| C-18 | 機能No.24 名前変更が主機能 | E-07 行27 | ○ |
| C-19 | 機能No.124 Copilot連携が補助機能 | E-07 行28 | ○ |
| C-20 | 画面種別はエディタ機能-インラインリネーム | E-09 行22 | ○ |
| C-21 | PositionAdornmentでフライアウト位置を調整 | E-02 行132-158 | ○ |
| C-22 | IsExpandedで展開状態を管理 | E-03 行209-213 | ○ |
| C-23 | SubmitTextで操作ヒントを表示 | E-02 行112-115, E-01 行138-144 | ○ |
| C-24 | AllowFileRenameでファイルリネーム可否を制御 | E-03 行97 | ○ |
| C-25 | メニューからもリネーム機能にアクセス可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- C-25: メニューバーからのアクセス経路について
  - Visual Studioのメニュー構成は本プロジェクト外で定義されているため、Roslynソースからは確認不可
  - 候補：Visual Studio SDK ドキュメント / VSCT ファイル / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全体として高い信頼度を維持
- 1: 中リスク - Copilot連携機能は外部サービス依存のため、実行時動作の確認推奨

## 6) レビュアーチェックリスト（最小）

- [ ] F2キーでリネームフライアウトが正しく表示されることを確認
- [ ] 各オプション（オーバーロード、コメント、文字列、ファイル）が正しく動作することを確認
- [ ] Enter/Escapeキーの動作を確認
- [ ] Copilot有効時のスマートリネーム機能の動作確認
- [ ] エラー・警告メッセージの表示確認
