---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-リネームユーザー入力テキストボックス画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml` (行1-10)
- E-02: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameUserInputTextBox.xaml.cs` (行1-72)
- E-03: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml.cs` (行49)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行29)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (行23)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TextBoxを継承したコントロールである | E-02 行14 | ○ |
| C-02 | IRenameUserInputインターフェースを実装 | E-02 行14 | ○ |
| C-03 | コンストラクタでViewModelをDataContextに設定 | E-02 行16-20 | ○ |
| C-04 | TextSelectionStartプロパティを提供 | E-02 行22-26 | ○ |
| C-05 | TextSelectionLengthプロパティを提供 | E-02 行28-32 | ○ |
| C-06 | TextSelectionChangedイベントを提供 | E-02 行34-44 | ○ |
| C-07 | PreviewKeyDownイベントを提供 | E-02 行46-56 | ○ |
| C-08 | SelectTextメソッドを実装 | E-02 行58-61 | ○ |
| C-09 | SelectAllTextメソッドを実装 | E-02 行63-66 | ○ |
| C-10 | Focusメソッドを実装 | E-02 行68-71 | ○ |
| C-11 | VsResourceKeys.TextBoxStyleKeyでスタイル適用 | E-01 行9 | ○ |
| C-12 | IdentifierTextプロパティにバインディング | E-01 行10 | ○ |
| C-13 | UpdateSourceTrigger=PropertyChangedを使用 | E-01 行10 | ○ |
| C-14 | SmartRenameViewModelがnullの場合に使用される | E-03 行49 | ○ |
| C-15 | 機能No.24 名前変更の補助機能として定義 | E-04 行29 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - シンプルなコントロールで、全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] テキスト入力が正しくViewModelに反映されることを確認
- [ ] テキスト選択操作（SelectAll、Select）が正しく動作することを確認
- [ ] Visual Studioテーマに応じたスタイルが適用されていることを確認
