---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-スマートリネームステータスコントロール画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameStatusControl.xaml` (行1-26)
- E-02: `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameStatusControl.xaml.cs` (行1-19)
- E-03: `src/EditorFeatures/Core/InlineRename/UI/SmartRename/SmartRenameViewModel.cs` (行84-86)
- E-04: `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml.cs` (行77-81)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行33-34)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UserControlを継承している | E-01 行1 | ○ |
| C-02 | コンストラクタでViewModelをDataContextに設定 | E-02 行14-17 | ○ |
| C-03 | StatusMessageプロパティにバインディング | E-01 行22 | ○ |
| C-04 | StatusMessageVisibilityで表示制御 | E-01 行23 | ○ |
| C-05 | MaxWidth=400で最大幅を制限 | E-01 行20 | ○ |
| C-06 | TextWrapping=Wrapでテキスト折り返し | E-01 行21 | ○ |
| C-07 | ComboBoxPopupBackgroundGradientBrushKeyを背景に使用 | E-01 行16 | ○ |
| C-08 | Margin="0 0 0 5"で下マージンを設定 | E-01 行11 | ○ |
| C-09 | SmartRenameViewModelがnullでない場合に追加される | E-04 行77-81 | ○ |
| C-10 | SmartRenameViewModelからStatusMessageを取得 | E-03 行84-86 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - シンプルな表示コントロール

## 6) レビュアーチェックリスト（最小）

- [ ] ステータスメッセージが正しく表示されることを確認
- [ ] StatusMessageVisibilityがfalseの場合に非表示になることを確認
- [ ] 長いメッセージが適切に折り返されることを確認
