---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-オンザフライドキュメントビュー画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/EditorFeatures/Core/QuickInfo/OnTheFlyDocsView.xaml` (行1-32)
- E-02: `src/EditorFeatures/Core/QuickInfo/OnTheFlyDocsView.xaml.cs` (行1-326)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行35-36)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行27)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UserControlを継承している | E-01 行1, E-02 行39 | ○ |
| C-02 | INotifyPropertyChangedを実装 | E-02 行39 | ○ |
| C-03 | CurrentStateプロパティで状態管理 | E-02 行283-287 | ○ |
| C-04 | OnDemandLink状態でDescribeリンク表示 | E-01 行15-19, E-02 行92-102 | ○ |
| C-05 | Loading状態でプログレスバー表示 | E-01 行20-24, E-02 行104-111 | ○ |
| C-06 | Finished状態で結果表示 | E-01 行25-29, E-02 行120-132 | ○ |
| C-07 | ResultsRequestedイベントが存在 | E-02 行59 | ○ |
| C-08 | PlanUpgradeRequestedイベントが存在 | E-02 行64 | ○ |
| C-09 | ICopilotCodeAnalysisServiceを使用 | E-02 行174-175 | ○ |
| C-10 | GetOnTheFlyDocsPromptAsyncを呼び出し | E-02 行191 | ○ |
| C-11 | GetOnTheFlyDocsResponseAsyncを呼び出し | E-02 行192 | ○ |
| C-12 | クォータ超過時にアップグレード誘導 | E-02 行202-226 | ○ |
| C-13 | Copilotスパークルアイコンを使用 | E-02 行91 | ○ |
| C-14 | SmoothProgressBarを使用 | E-02 行110 | ○ |
| C-15 | キャンセル時にテレメトリログ記録 | E-02 行251-256 | ○ |
| C-16 | IsContentExcludedでリンク無効化 | E-02 行92-93 | ○ |
| C-17 | 機能No.19 クイック情報が主機能 | E-03 行35 | ○ |
| C-18 | 機能No.124 Copilot連携が補助機能 | E-03 行36 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 1: 中リスク - Copilot連携は外部サービス依存のため、実行時動作の確認推奨

## 6) レビュアーチェックリスト（最小）

- [ ] 「Describe」リンクが正しく表示されることを確認
- [ ] クリック後にローディング状態が表示されることを確認
- [ ] 生成されたドキュメントが正しく表示されることを確認
- [ ] クォータ超過時のメッセージとアップグレードリンクを確認
- [ ] コンテンツ除外時の無効化表示を確認
