---
generated_at: 2026-02-10 11:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-オプションプレビューコントロール画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Impl/Options/OptionPreviewControl.xaml` (行1-62)
- E-02: `src/VisualStudio/Core/Impl/Options/OptionPreviewControl.xaml.cs` (行1-98)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行38)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行29)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractOptionPageControlを継承 | E-01 行1-2, E-02 行18 | ○ |
| C-02 | AbstractCheckBoxViewModelのDataTemplateが存在 | E-01 行16-27 | ○ |
| C-03 | HeaderItemViewModelのDataTemplateが存在 | E-01 行29-31 | ○ |
| C-04 | AbstractRadioButtonViewModelのDataTemplateが存在 | E-01 行33-45 | ○ |
| C-05 | AutomationDelegatingListViewを使用 | E-02 行34 | ○ |
| C-06 | Options_SelectionChangedでプレビュー更新 | E-02 行48-60 | ○ |
| C-07 | Options_PreviewKeyDownでSpaceキー処理 | E-02 行62-79 | ○ |
| C-08 | CheckBoxViewModelのIsChecked反転処理 | E-02 行69 | ○ |
| C-09 | RadioButtonViewModelのIsChecked設定処理 | E-02 行75 | ○ |
| C-10 | EditorControlでプレビュー表示 | E-01 行59 | ○ |
| C-11 | CodeStyleNoticeTextBlockを含む | E-01 行54 | ○ |
| C-12 | OnLoadでViewModelを作成 | E-02 行81-90 | ○ |
| C-13 | CloseでViewModelをDispose | E-02 行92-97 | ○ |
| C-14 | 機能No.116 コードスタイル分析が主機能 | E-03 行38 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 標準的なオプションページコントロール

## 6) レビュアーチェックリスト（最小）

- [ ] チェックボックスのオン/オフが正しく動作することを確認
- [ ] ラジオボタンの選択が正しく動作することを確認
- [ ] オプション選択時にプレビューが正しく更新されることを確認
- [ ] Spaceキーでオプションが切り替わることを確認
