---
generated_at: 2026-02-10 11:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-コードスタイル通知テキストブロック画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.xaml` (行1-18)
- E-02: `src/VisualStudio/Core/Impl/Options/CodeStyleNoticeTextBlock.xaml.cs` (行1-35)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行39)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行30)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TextBlockを継承している | E-01 行1, E-02 行14 | ○ |
| C-02 | CodeStylePageHeader静的プロパティが存在 | E-02 行22 | ○ |
| C-03 | CodeStylePageHeaderLearnMoreText静的プロパティが存在 | E-02 行23 | ○ |
| C-04 | CodeStylePageHeaderLearnMoreUri静的プロパティが存在 | E-02 行21 | ○ |
| C-05 | UseEditorConfigUrl定数が定義 | E-02 行16 | ○ |
| C-06 | Run要素でヘッダーテキストを表示 | E-01 行11 | ○ |
| C-07 | Hyperlink要素でLearn Moreリンクを表示 | E-01 行13-17 | ○ |
| C-08 | LearnMoreHyperlink_RequestNavigateメソッドが存在 | E-02 行25-34 | ○ |
| C-09 | VisualStudioNavigateToLinkService.StartBrowserを使用 | E-02 行32 | ○ |
| C-10 | 機能No.116 コードスタイル分析が補助機能 | E-03 行39 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - シンプルな表示コントロール

## 6) レビュアーチェックリスト（最小）

- [ ] テキストが正しく表示されることを確認
- [ ] 「Learn more」リンクをクリックするとブラウザが起動することを確認
- [ ] リンク先のURLが正しいことを確認
