---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-型生成ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **TrySubmitのバリデーション詳細**：ViewModelのソースコード確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialog.xaml` (行1-168)
- E-02: `src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialog.xaml.cs` (行1-143)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行4)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行5)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (行36)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 新しい型（クラス、インターフェース等）を生成するダイアログ | E-03 | ○ |
| C-02 | アクセス修飾子の選択ComboBox | E-01 行43-54 | ○ |
| C-03 | 型種別の選択ComboBox | E-01 行55-64 | ○ |
| C-04 | 型名は読み取り専用TextBox | E-01 行65-77, Opacity=0.56 | ○ |
| C-05 | プロジェクト選択ComboBox | E-01 行83-100 | ○ |
| C-06 | 新規ファイル作成のRadioButton | E-01 行104-109 | ○ |
| C-07 | 新規ファイル名入力ComboBox（編集可能） | E-01 行110-119, IsEditable=True | ○ |
| C-08 | 既存ファイル選択のRadioButton | E-01 行120-126 | ○ |
| C-09 | 既存ファイル選択ComboBox | E-01 行127-143 | ○ |
| C-10 | OK/Cancelボタン | E-01 行145-165 | ○ |
| C-11 | ヘルプトピックはvsl.GenerateFromUsage | E-02 行36 | ○ |
| C-12 | ダイアログサイズ460x353、最小370x460 | E-01 行12-13 | ○ |
| C-13 | VSThemeDictionary.xaml参照 | E-01 行23-25 | ○ |
| C-14 | Alt+Aでアクセス選択にフォーカス | E-02 行47-52 | ○ |
| C-15 | Alt+Kで型種別にフォーカス | E-02 行54-59 | ○ |
| C-16 | Alt+Pでプロジェクト選択にフォーカス | E-02 行61-66 | ○ |
| C-17 | Alt+Cで新規ファイルにフォーカス | E-02 行68-73 | ○ |
| C-18 | Alt+Xで既存ファイルにフォーカス | E-02 行75-80 | ○ |
| C-19 | ファイル名フォーカス喪失時に拡張子更新 | E-02 行98-99, E-01 行118 | ○ |
| C-20 | OK_ClickでTrySubmit実行 | E-02 行101-108 | ○ |
| C-21 | 機能マッピングとの整合性（型生成が主機能） | E-04 | ○ |
| C-22 | バリデーション失敗時のエラーメッセージ詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- GenerateTypeDialogViewModel.TrySubmit()の詳細なバリデーションロジック
  - 候補：`src/VisualStudio/Core/Def/GenerateType/GenerateTypeDialogViewModel.cs`

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - UI構成は明確に文書化
- 1: 中リスク - バリデーションエラーメッセージの詳細は要確認

## 6) レビュアーチェックリスト（最小）

- [ ] キーボードショートカットの一覧は正確か
- [ ] プロジェクト選択による連動更新の説明は十分か
- [ ] 画面遷移図との整合性を確認したか
