---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-命名スタイルオプションページコントロール画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyleOptionPageControl.xaml` (行1-284)
- E-02: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyleOptionPageControl.xaml.cs` (行1-196)
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行40)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行31)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractOptionPageControlを継承 | E-01 行1-2, E-02 行23 | ○ |
| C-02 | ReorderHeader列が存在 | E-01 行116-153 | ○ |
| C-03 | SpecificationHeader列（symbolSpec）が存在 | E-01 行154-177 | ○ |
| C-04 | RequiredStyleHeader列（style）が存在 | E-01 行178-201 | ○ |
| C-05 | SeverityHeader列が存在 | E-01 行202-242 | ○ |
| C-06 | Delete列が存在 | E-01 行243-260 | ○ |
| C-07 | AddButton_Clickメソッドが存在 | E-02 行68-69 | ○ |
| C-08 | RemoveButton_Clickメソッドが存在 | E-02 行113-118 | ○ |
| C-09 | MoveUp_Clickメソッドが存在 | E-02 行91-100 | ○ |
| C-10 | MoveDown_Clickメソッドが存在 | E-02 行102-111 | ○ |
| C-11 | ManageSpecificationsButton_Clickメソッドが存在 | E-02 行71-79 | ○ |
| C-12 | ManageStylesButton_Clickメソッドが存在 | E-02 行81-89 | ○ |
| C-13 | OnSaveでNamingStylePreferencesを保存 | E-02 行138-175 | ○ |
| C-14 | OnLoadでNamingStylePreferencesを読み込み | E-02 行177-189 | ○ |
| C-15 | NotificationOptionViewModelで通知レベルを管理 | E-02 行40-46 | ○ |
| C-16 | Alt+↑/↓のキーボードショートカット | E-01 行42-43 | ○ |
| C-17 | CodeStyleNoticeTextBlockを含む | E-01 行52 | ○ |
| C-18 | ExplanatoryTextを表示 | E-01 行51, E-02 行29 | ○ |
| C-19 | ContainsErrorsメソッドが存在 | E-02 行191-192 | ○ |
| C-20 | 機能No.116 コードスタイル分析が主機能 | E-03 行40 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 標準的なオプションページコントロール

## 6) レビュアーチェックリスト（最小）

- [ ] ルールの追加が正しく動作することを確認
- [ ] ルールの削除が正しく動作することを確認
- [ ] ルールの並び替えが正しく動作することを確認
- [ ] シンボル仕様/命名スタイルの管理ダイアログが正しく動作することを確認
- [ ] 設定の保存/読み込みが正しく動作することを確認
- [ ] 不完全なルール（仕様やスタイルが未選択）が保存時にスキップされることを確認
