---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-命名スタイルダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **画面遷移の詳細**：命名スタイルオプションページからの遷移パスはコードから推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleDialog.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleDialog.xaml.cs`（コードビハインド）
- E-03: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/NamingStyles/NamingStyleViewModel.cs`（ビューモデル）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`（画面遷移図）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ダイアログサイズは幅500px、高さ280px | E-01（13-14行目: Height="280" Width="500"） | ○ |
| C-02 | ダイアログタイトルは「Naming Style」 | E-02（20行目: DialogTitle => ServicesVSResources.Naming_Style） | ○ |
| C-03 | スタイル名テキストボックスはItemNameにバインド | E-01（53行目: Text="{Binding ItemName, ...}"） | ○ |
| C-04 | 必須プレフィックスはRequiredPrefixにバインド | E-01（64行目: Text="{Binding RequiredPrefix, ...}"） | ○ |
| C-05 | 必須サフィックスはRequiredSuffixにバインド | E-01（74行目: Text="{Binding RequiredSuffix, ...}"） | ○ |
| C-06 | 単語区切り文字はWordSeparatorにバインド | E-01（84行目: Text="{Binding WordSeparator, ...}"） | ○ |
| C-07 | 大文字化規則コンボボックスはCapitalizationSchemesにバインド | E-01（95-97行目: ItemsSource, SelectedIndex） | ○ |
| C-08 | サンプル識別子は読み取り専用 | E-01（103行目: IsReadOnly="True"） | ○ |
| C-09 | OKボタン押下時にTrySubmitを呼び出す | E-02（38-44行目: OK_Click, TrySubmit()） | ○ |
| C-10 | スタイル名が空白の場合エラー通知 | E-03（139-142行目: string.IsNullOrWhiteSpace, SendNotification） | ○ |
| C-11 | キャンセルボタン押下時にDialogResult=false | E-02（46-47行目: Cancel_Click, DialogResult = false） | ○ |
| C-12 | 大文字化規則はPascalCase等5種類 | E-03（34-38行目: CapitalizationSchemes配列） | ○ |
| C-13 | サンプル識別子は「example」「identifier」を使用 | E-03（76行目: CreateName with example, identifier） | ○ |
| C-14 | 関連機能No.116（コードスタイル分析） | E-05（41行目: 画面No 31, 機能No 116） | ○ |
| C-15 | 画面種別は編集ダイアログ | E-04（32行目: 命名スタイルを編集するダイアログ） | ○ |
| C-16 | ViewModelはAbstractNotifyPropertyChangedを継承 | E-03（16行目: class NamingStyleViewModel : AbstractNotifyPropertyChanged） | ○ |
| C-17 | プロパティ変更時にCurrentConfigurationが再計算される | E-03（56-59行目, 94-97行目等: NotifyPropertyChanged(nameof(CurrentConfiguration))） | ○ |
| C-18 | 命名スタイルオプションページから遷移 | E-06（推測、直接的なコード根拠なし） | △ |

## 4) 不足情報（Unknown / Missing）
- 命名スタイルオプションページ（No.30）からの具体的な遷移コード
  - 候補：NamingStyleOptionPageControl.xaml.cs / ManageNamingStylesInfoDialogの呼び出し元

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] スタイル名の入力検証ロジックが正しいか確認
- [ ] 大文字化規則の選択肢が最新のコードと一致しているか確認
- [ ] 画面遷移の記述が実際のユーザー操作と一致するか確認
