---
generated_at: 2026-02-10 10:32:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-シンボル仕様ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationDialog.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/SymbolSpecification/SymbolSpecificationDialog.xaml.cs`（コードビハインド）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ダイアログサイズは幅700px、高さ450px | E-01（13-14行目: Height="450" Width="700"） | ○ |
| C-02 | 最小サイズは600x400 | E-01（14行目: MinHeight="400" MinWidth="600"） | ○ |
| C-03 | ダイアログタイトルは「Symbol Specification」 | E-02（23行目: DialogTitle => ServicesVSResources.Symbol_Specification） | ○ |
| C-04 | シンボル種類ラベルは「can match any」 | E-02（25行目: SymbolKindsLabelText => ServicesVSResources.Symbol_Kinds_can_match_any） | ○ |
| C-05 | アクセス修飾子ラベルは「can match any」 | E-02（26行目: AccessibilitiesLabelText => ServicesVSResources.Accessibilities_can_match_any） | ○ |
| C-06 | 修飾子ラベルは「must match all」 | E-02（27行目: ModifiersLabelText => ServicesVSResources.Modifiers_must_match_all） | ○ |
| C-07 | AutomationDelegatingListViewをコードで生成 | E-02（50-57行目: CreateAutomationDelegatingListView呼び出し） | ○ |
| C-08 | Spaceキーで選択アイテムをトグル | E-02（84-96行目: HandlePreviewKeyDown, Key.Space） | ○ |
| C-09 | 全選択ボタンでIsChecked=trueに設定 | E-02（98-104行目: SelectAllSymbolKinds） | ○ |
| C-10 | 全解除ボタンでIsChecked=falseに設定 | E-02（106-112行目: DeselectAllSymbolKinds） | ○ |
| C-11 | OKボタンでTrySubmitを呼び出す | E-02（146-152行目: OK_Click） | ○ |
| C-12 | キャンセルボタンでDialogResult=false | E-02（154-155行目: Cancel_Click） | ○ |
| C-13 | listViewDataTemplateでCheckBoxを使用 | E-01（30-38行目: DataTemplate with CheckBox） | ○ |
| C-14 | 関連機能No.116（コードスタイル分析） | E-04（42行目: 画面No 32, 機能No 116） | ○ |
| C-15 | 画面種別はシンボル仕様編集ダイアログ | E-03（33行目: シンボル仕様を編集するダイアログ） | ○ |
| C-16 | 2カラムレイアウト構成 | E-01（55-58行目: Grid.ColumnDefinitions with 1*, 1*） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] シンボル種類のリストが最新のRoslyn APIと一致しているか確認
- [ ] アクセス修飾子のリストが最新のRoslyn APIと一致しているか確認
- [ ] 修飾子のリストが最新のRoslyn APIと一致しているか確認
