---
generated_at: 2026-02-10 10:34:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-命名スタイル情報管理ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/ManageNamingStylesInfoDialog.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Impl/Options/Style/NamingPreferences/ManageNamingStylesInfoDialog.xaml.cs`（コードビハインド）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ダイアログサイズは幅300px、高さ400px | E-01（16-18行目: Height="400" Width="300"） | ○ |
| C-02 | ダイアログタイトルはViewModelから取得 | E-01（19行目: Title="{Binding DialogTitle}"） | ○ |
| C-03 | DataGridは読み取り専用 | E-01（71行目: IsReadOnly="True"） | ○ |
| C-04 | ヘッダーは非表示 | E-01（80行目: HeadersVisibility="None"） | ○ |
| C-05 | 削除不可の説明はツールチップで表示 | E-02（23行目: CannotBeDeletedExplanation => ServicesVSResources.This_item_cannot_be_deleted...） | ○ |
| C-06 | AddButton_ClickでAddItem呼び出し | E-02（36-37行目: AddButton_Click → _viewModel.AddItem()） | ○ |
| C-07 | RemoveButton_ClickでRemoveItem呼び出し | E-02（39-44行目: RemoveButton_Click → _viewModel.RemoveItem(item)） | ○ |
| C-08 | EditButton_ClickでEditItem呼び出し | E-02（46-51行目: EditButton_Click → _viewModel.EditItem(item)） | ○ |
| C-09 | OK_ClickでDialogResult=true | E-02（53-54行目: OK_Click → DialogResult = true） | ○ |
| C-10 | Cancel_ClickでDialogResult=false | E-02（56-57行目: Cancel_Click → DialogResult = false） | ○ |
| C-11 | 編集ボタンはKnownMonikers.Editを使用 | E-01（140-143行目: Moniker="{x:Static imagecatalog:KnownMonikers.Edit}"） | ○ |
| C-12 | 削除ボタンはKnownMonikers.DeleteListItemを使用 | E-01（163-167行目: Moniker="{x:Static imagecatalog:KnownMonikers.DeleteListItem}"） | ○ |
| C-13 | 追加ボタンはKnownMonikers.Addを使用 | E-01（183-186行目: Moniker="{x:Static imagecatalog:KnownMonikers.Add}"） | ○ |
| C-14 | CanBeDeletedでグレースケール制御 | E-01（165行目: Grayscale="{Binding CanBeDeleted, Converter={StaticResource NegateBooleanConverter}}"） | ○ |
| C-15 | 関連機能No.116（コードスタイル分析）補助機能 | E-04（43行目: 画面No 33, 機能No 116, 補助機能） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] IManageNamingStylesInfoDialogViewModelの具体的な実装クラスを確認
- [ ] 削除不可条件の詳細ロジックを確認
- [ ] 追加・編集時の子ダイアログ表示ロジックを確認
