---
generated_at: 2026-02-10 10:36:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-C#詳細オプションページコントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml`（XAML定義）
- E-02: `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml.cs`（コードビハインド）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractOptionPageControlを継承 | E-02（45行目: class AdvancedOptionPageControl : AbstractOptionPageControl） | ○ |
| C-02 | ScrollViewerで縦スクロール可能 | E-01（13行目: ScrollViewer VerticalScrollBarVisibility="Auto"） | ○ |
| C-03 | Analysisグループボックスが存在 | E-01（21行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Option_Analysis}"） | ○ |
| C-04 | バックグラウンド分析スコープのコンボボックス | E-01（26-31行目: ComboBox Run_background_code_analysis_for） | ○ |
| C-05 | BindToOptionでオプションバインディング | E-02（52行目: BindToOption(Run_background_code_analysis_for, SolutionCrawlerOptionsStorage.BackgroundAnalysisScopeOption, ...）） | ○ |
| C-06 | ソースジェネレーターグループボックス | E-01（66行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Option_Source_Generators}"） | ○ |
| C-07 | Go To Definitionグループボックス | E-01（86行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Option_Go_To_Definition}"） | ○ |
| C-08 | Using Directivesグループボックス | E-01（98行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Option_Using_Directives}"） | ○ |
| C-09 | Highlightingグループボックス | E-01（119行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Option_Highlighting}"） | ○ |
| C-10 | Outliningグループボックス | E-01（129行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Option_Outlining}"） | ○ |
| C-11 | EnterOutliningMode_Checkedイベントハンドラ | E-02（218-224行目: EnterOutliningMode_Checked） | ○ |
| C-12 | EnterOutliningMode_Uncheckedイベントハンドラ | E-02（226-232行目: EnterOutliningMode_Unchecked） | ○ |
| C-13 | Inline Hintsグループボックス | E-01（274行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Option_Inline_Hints}"） | ○ |
| C-14 | DisplayInlineParameterNameHintsバインディング | E-02（142行目: BindToOption(DisplayInlineParameterNameHints, InlineHintsOptionsStorage.EnabledForParameters, ...）） | ○ |
| C-15 | DisplayInlineTypeHintsバインディング | E-02（151行目: BindToOption(DisplayInlineTypeHints, InlineHintsOptionsStorage.EnabledForTypes, ...）） | ○ |
| C-16 | Inheritance Marginグループボックス | E-01（339行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Inheritance_Margin}"） | ○ |
| C-17 | Stack Trace Explorerグループボックス | E-01（353行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Stack_Trace_Explorer}"） | ○ |
| C-18 | OnLoadでインラインヒントオプション更新 | E-02（169-174行目: OnLoad → UpdateInlineHintsOptions） | ○ |
| C-19 | 関連機能No.101（VS C#拡張） | E-04（44行目: 画面No 34, 機能No 101） | ○ |
| C-20 | LanguageNames.CSharpで言語固有設定 | E-02（52行目: LanguageNames.CSharp） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 設定項目の完全性を確認（すべてのグループボックスがドキュメントに記載されているか）
- [ ] BindToOption呼び出しの正確性を確認
- [ ] 依存関係のある設定の有効/無効化ロジックを確認
