---
generated_at: 2026-02-10 10:38:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-C#書式設定オプションページコントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/CSharp/Impl/Options/Formatting/FormattingOptionPageControl.xaml`（XAML定義）
- E-02: `src/VisualStudio/CSharp/Impl/Options/Formatting/FormattingOptionPageControl.xaml.cs`（コードビハインド）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractOptionPageControlを継承 | E-02（23行目: class FormattingOptionPageControl : AbstractOptionPageControl） | ○ |
| C-02 | ScrollViewerで縦スクロール可能 | E-01（13行目: ScrollViewer VerticalScrollBarVisibility="Auto"） | ○ |
| C-03 | CodeStyleNoticeTextBlockを配置 | E-01（15行目: localOptions:CodeStyleNoticeTextBlock） | ○ |
| C-04 | Generalグループボックスが存在 | E-01（16行目: GroupBox Header="{x:Static local:FormattingGeneralOptionPageStrings.General}"） | ○ |
| C-05 | FormatWhenTypingCheckBoxが存在 | E-01（18行目: CheckBox x:Name="FormatWhenTypingCheckBox"） | ○ |
| C-06 | 子チェックボックスはインデント付き | E-01（19行目: StackPanel Margin="15, 0, 0, 0"） | ○ |
| C-07 | 子チェックボックスは親に依存して有効/無効化 | E-01（19行目: IsEnabled="{Binding ElementName=FormatWhenTypingCheckBox, Path=IsChecked}"） | ○ |
| C-08 | FormatOnSemicolonCheckBoxが存在 | E-01（20行目: CheckBox x:Name="FormatOnSemicolonCheckBox"） | ○ |
| C-09 | FormatOnCloseBraceCheckBoxが存在 | E-01（21行目: CheckBox x:Name="FormatOnCloseBraceCheckBox"） | ○ |
| C-10 | FormatOnReturnCheckBoxが存在 | E-01（23行目: CheckBox x:Name="FormatOnReturnCheckBox"） | ○ |
| C-11 | FormatOnPasteCheckBoxが存在 | E-01（24行目: CheckBox x:Name="FormatOnPasteCheckBox"） | ○ |
| C-12 | BindToOptionでAutoFormattingOptionsStorageをバインド | E-02（35-38行目: BindToOption） | ○ |
| C-13 | BindToOptionでFormattingOptionsStorageをバインド | E-02（39行目: FormattingOptionsStorage.FormatOnPaste） | ○ |
| C-14 | 関連機能No.76（フォーマット） | E-04（45行目: 画面No 35, 機能No 76） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ローカライズ文字列（CSharpVSResources）の内容を確認
- [ ] CodeStyleNoticeTextBlockの警告内容を確認
- [ ] 親子チェックボックスの依存関係が正しく動作することを確認
