---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-VB詳細オプションページコントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPageControl.xaml`（XAML定義）
- E-02: `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPageControl.xaml.vb`（コードビハインド）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractOptionPageControlを継承 | E-02（41行目: Inherits AbstractOptionPageControl） | ○ |
| C-02 | ScrollViewerで縦スクロール可能 | E-01（13行目: ScrollViewer VerticalScrollBarVisibility="Auto"） | ○ |
| C-03 | Analysisグループボックスが存在 | E-01（21行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Option_Analysis}"） | ○ |
| C-04 | Import Directivesグループボックス | E-01（86行目: GroupBox Header="{x:Static local:AdvancedOptionPageStrings.Option_Import_Directives}"） | ○ |
| C-05 | EnableEndConstruct設定 | E-02（107行目: BindToOption(EnableEndConstruct, EndConstructGenerationOptionsStorage.EndConstruct, ...）） | ○ |
| C-06 | EnableLineCommit設定 | E-02（108行目: BindToOption(EnableLineCommit, LineCommitOptionsStorage.PrettyListing, ...）） | ○ |
| C-07 | インターフェースメンバー自動挿入設定 | E-02（109行目: BindToOption(AutomaticInsertionOfInterfaceAndMustOverrideMembers, ...）） | ○ |
| C-08 | オブジェクトブラウザナビゲート設定 | E-02（117行目: BindToOption(NavigateToObjectBrowser, VisualStudioNavigationOptionsStorage.NavigateToObjectBrowser, ...）） | ○ |
| C-09 | EnableOutlining_Checkedイベントハンドラ | E-02（184-189行目: EnableOutlining_Checked） | ○ |
| C-10 | EnableOutlining_Uncheckedイベントハンドラ | E-02（191-196行目: EnableOutlining_Unchecked） | ○ |
| C-11 | DisplayInlineParameterNameHints_Checked | E-02（174-177行目） | ○ |
| C-12 | DisplayInlineParameterNameHints_Unchecked | E-02（179-182行目） | ○ |
| C-13 | インライン型ヒントの設定なし | E-01、E-02（DisplayInlineTypeHintsが存在しない） | ○ |
| C-14 | コメント設定はアポストロフィベース | E-01（173行目: GenerateXmlDocCommentsForTripleApostrophes） | ○ |
| C-15 | Inheritance Marginグループボックス | E-01（312行目: InheritanceMarginGroupbox） | ○ |
| C-16 | LanguageNames.VisualBasicで言語固有設定 | E-02（50行目: LanguageNames.VisualBasic） | ○ |
| C-17 | 関連機能No.102（VS VB拡張） | E-04（46行目: 画面No 36, 機能No 102） | ○ |
| C-18 | C#詳細設定と類似構成 | E-03（37行目: C#詳細設定と類似の構成） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] VB固有機能（End Construct、Line Commit）の動作を確認
- [ ] C#との設定差異が正しく記載されているか確認
- [ ] VBローカライズ文字列の正確性を確認
