---
generated_at: 2026-02-10 10:46:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-空白ブール設定ビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/EditorConfigSettings/Whitespace/View/WhitespaceBoolSettingView.xaml`（XAML定義）
- E-02: `src/VisualStudio/Core/Def/EditorConfigSettings/Whitespace/View/WhitespaceBoolSettingView.xaml.cs`（コードビハインド）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（画面一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UserControlを継承 | E-02（13行目: class WhitespaceBoolSettingView : UserControl） | ○ |
| C-02 | WhitespaceSettingBoolViewModelをDataContextに設定 | E-02（18行目: DataContext = viewModel） | ○ |
| C-03 | CheckBoxがルートコントロール | E-01（26行目: CheckBox x:Name="RootCheckBox"） | ○ |
| C-04 | IsCheckedバインディング | E-01（27行目: IsChecked="{Binding IsChecked}"） | ○ |
| C-05 | ToolTipバインディング | E-01（28行目: ToolTip="{Binding ToolTip}"） | ○ |
| C-06 | AutomationProperties.Nameバインディング | E-01（29行目: AutomationProperties.Name="{Binding AutomationName}"） | ○ |
| C-07 | FocusVisualStyleの定義 | E-01（11-23行目: Style x:Key="FocusVisualStyleKey"） | ○ |
| C-08 | HighContrastモード対応 | E-01（33行目: Tag="{DynamicResource {x:Static SystemParameters.HighContrastKey}}"） | ○ |
| C-09 | CommonControlsColorsのブラシを使用 | E-01（34行目, 46行目等: vs:CommonControlsColors.*BrushKey） | ○ |
| C-10 | CheckMarkパス要素 | E-01（49-56行目: Path x:Name="CheckMark"） | ○ |
| C-11 | IndeterminateMarkレクタングル | E-01（57-60行目: Rectangle x:Name="IndeterminateMark"） | ○ |
| C-12 | IsChecked=trueでCheckMark表示 | E-01（77-78行目: Trigger Property="IsChecked" Value="true"） | ○ |
| C-13 | IsChecked=nullでIndeterminateMark表示 | E-01（80-81行目: Trigger Property="IsChecked" Value="{x:Null}"） | ○ |
| C-14 | 関連機能No.116（コードスタイル分析）補助機能 | E-04（49行目: 画面No 39, 機能No 116, 補助機能） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] VS Theme各モード（Light、Dark、Blue、High Contrast）での表示を確認
- [ ] キーボード操作でのフォーカス視覚表示を確認
- [ ] ToolTip表示の動作を確認
