---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-クラス抽出ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/ExtractClass/ExtractClassDialog.xaml` (行1-72)
- E-02: `src/VisualStudio/Core/Def/ExtractClass/ExtractClassDialog.xaml.cs` (行1-46)
- E-03: `src/VisualStudio/Core/Def/CommonControls/NewTypeDestinationSelection.xaml` (行1-108)
- E-04: `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml` (行1-202)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (行5)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行6-7)
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` (行37, 51-52)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 既存クラスから新しいクラスを抽出する | E-05 | ○ |
| C-02 | 抽出先の設定とメンバー選択 | E-05, E-06 | ○ |
| C-03 | NewTypeDestinationSelectionコントロールを使用 | E-01 行37 | ○ |
| C-04 | MemberSelectionコントロールを使用 | E-02 行29, E-01 行45 | ○ |
| C-05 | ダイアログサイズ500x498、最小510x498 | E-01 行14-17 | ○ |
| C-06 | リサイズ可能（CanResizeWithGrip） | E-01 行20 | ○ |
| C-07 | VSThemeDictionary.xaml参照 | E-01 行24-26 | ○ |
| C-08 | OK/Cancelボタン | E-01 行48-70 | ○ |
| C-09 | TitleプロパティはViewModelから取得 | E-01 行12, E-02 行21 | ○ |
| C-10 | OK_ClickでTrySubmit実行 | E-02 行36-42 | ○ |
| C-11 | 配置先コントロールで新しい型名入力 | E-03 行34-44 | ○ |
| C-12 | 配置先コントロールで生成名表示（読み取り専用） | E-03 行45-55 | ○ |
| C-13 | 配置先コントロールでラジオボタン選択 | E-03 行71-93 | ○ |
| C-14 | メンバー選択コントロールでDataGrid表示 | E-04 行35-154 | ○ |
| C-15 | メンバー選択コントロールでチェックボックス | E-04 行72-88 | ○ |
| C-16 | メンバー選択コントロールで抽象化チェック | E-04 行130-152 | ○ |
| C-17 | SelectAllボタン | E-04 行162-170 | ○ |
| C-18 | DeselectAllボタン | E-04 行171-179 | ○ |
| C-19 | 機能マッピングとの整合性（クラス抽出が主機能） | E-06 行6 | ○ |
| C-20 | 画面遷移図との整合性 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 共通コントロールを使用しており、UI構成は明確
- 0: 低リスク - 機能マッピングとの整合性確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] NewTypeDestinationSelectionコントロールの仕様は正確か
- [ ] MemberSelectionコントロールの抽象化チェック機能は正確か
- [ ] 画面遷移図との整合性を確認したか
