---
generated_at: 2026-02-10 13:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-命名スタイルタイプコントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **シンボルタイプの完全な一覧**：NamingStyleSettingで利用可能なすべてのTypeNameの確認
  2. **SettingChangedイベントの発火タイミング**：どのような操作でイベントが発火するかの確認
  3. **メモリリーク対策**：イベント購読解除の実装確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesTypeControl.xaml` (行1-16)
- E-02: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesTypeControl.xaml.cs` (行1-20)
- E-03: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesTypeViewModel.cs` (行1-40)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行45)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行54)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 命名スタイルタイプコントロールはUserControlとして実装されている | E-01 (行1) | ○ |
| C-02 | Labelを使用してシンボルタイプを表示する | E-01 (行11-14) | ○ |
| C-03 | ContentプロパティにTypeValueがバインドされる | E-01 (行12) | ○ |
| C-04 | ToolTipプロパティにTypeToolTipがバインドされる | E-01 (行13) | ○ |
| C-05 | AutomationProperties.NameにTypeAutomationNameがバインドされる | E-01 (行14) | ○ |
| C-06 | ViewModelはNamingStylesTypeViewModelクラスである | E-01 (行7), E-02 (行15) | ○ |
| C-07 | 本コントロールは読み取り専用である | E-01, E-02 (編集機能なし) | ○ |
| C-08 | ViewModelはNotifyPropertyChangedBaseを継承している | E-03 (行10) | ○ |
| C-09 | TypeValueプロパティはNamingStyleSetting.TypeNameから取得される | E-03 (行19) | ○ |
| C-10 | SettingChangedイベントを購読している | E-03 (行18) | ○ |
| C-11 | OnSettingChangedでTypeValueが更新される | E-03 (行38-39) | ○ |
| C-12 | TypeToolTipは"Type"を返す静的プロパティである | E-03 (行35) | ○ |
| C-13 | TypeAutomationNameは"Type"を返す静的プロパティである | E-03 (行36) | ○ |
| C-14 | TypeValueのセッターにnullチェックがある | E-03 (行27) | ○ |
| C-15 | 関連機能は116（コードスタイル分析）である | E-05 | ○ |
| C-16 | 画面カテゴリはEditorConfig設定 - 命名スタイルである | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に根拠が存在します

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI構造に関する主張（C-01〜C-07）
- 0: 低リスク - ViewModel実装に関する主張（C-08〜C-14）
- 0: 低リスク - メタ情報に関する主張（C-15, C-16）

## 6) レビュアーチェックリスト（最小）
- [ ] Labelのバインディング設定がXAMLとViewModelで一致することを確認
- [ ] SettingChangedイベントの購読と購読解除が適切に行われていることを確認
- [ ] TypeValueのnullチェックロジックが正しいことを確認
- [ ] 静的プロパティ（TypeToolTip, TypeAutomationName）の値がリソースファイルと一致することを確認
