---
generated_at: 2026-02-10 13:55:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：46-命名スタイル重大度コントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **EditorConfigファイル読み取り専用時の挙動**：エラーハンドリングの詳細確認が必要
  2. **コードスタイル重大度との違い**：Disabled選択肢の有無の理由確認
  3. **ImmutableArrayの使用理由**：パフォーマンスとスレッドセーフティの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesSeverityControl.xaml` (行1-18)
- E-02: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesSeverityControl.xaml.cs` (行1-26)
- E-03: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesSeverityViewModel.cs` (行1-60)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行47)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行56)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 命名スタイル重大度コントロールはUserControlとして実装されている | E-01 (行1) | ○ |
| C-02 | ComboBoxを使用してドロップダウン選択を提供する | E-01 (行11-16) | ○ |
| C-03 | ItemsSourceにSeveritiesがバインドされる | E-01 (行12) | ○ |
| C-04 | SelectedValueにSelectedSeverityValueがバインドされる | E-01 (行13) | ○ |
| C-05 | ToolTipにSeverityToolTipがバインドされる | E-01 (行14) | ○ |
| C-06 | AutomationProperties.NameにSeverityAutomationNameがバインドされる | E-01 (行15) | ○ |
| C-07 | SelectionChangedイベントでViewModelに通知する | E-01 (行16), E-02 (行24-25) | ○ |
| C-08 | ViewModelはNamingStylesSeverityViewModelクラスである | E-01 (行7), E-02 (行15, 17) | ○ |
| C-09 | 重大度オプションは5つ（Disabled, Refactoring Only, Suggestion, Warning, Error）である | E-03 (行52-59) | ○ |
| C-10 | SeveritiesはImmutableArrayとして定義されている | E-03 (行52) | ○ |
| C-11 | コンストラクタで現在の重大度からインデックスに変換する | E-03 (行19-27) | ○ |
| C-12 | SelectionChangedメソッドはインデックスからReportDiagnosticに変換する | E-03 (行32-44) | ○ |
| C-13 | インデックス0はSuppress、1はHidden、2はInfo、3はWarn、4はErrorに対応する | E-03 (行34-40) | ○ |
| C-14 | 不正なインデックスでInvalidOperationExceptionがスローされる | E-03 (行41) | ○ |
| C-15 | SeverityToolTipは"Severity"を返す | E-03 (行46) | ○ |
| C-16 | SeverityAutomationNameは"Severity"を返す | E-03 (行48) | ○ |
| C-17 | 関連機能は116（コードスタイル分析）である | E-05 | ○ |
| C-18 | 画面カテゴリはEditorConfig設定 - 命名スタイルである | E-04 | ○ |
| C-19 | コードスタイル重大度と異なりDisabledオプションが含まれる | E-03 (行53) | ○ |
| C-20 | EditorConfigファイルが読み取り専用の場合は変更が反映されない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20について：EditorConfigファイルが読み取り専用の場合のエラーハンドリングに関するコードが確認できませんでした
  - 候補：NamingStyleSetting.ChangeSeverity / EditorTextUpdater.cs / Visual Studioファイル書き込みAPI

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI構造とバインディングに関する主張（C-01〜C-08）
- 0: 低リスク - ViewModel実装に関する主張（C-09〜C-16）
- 0: 低リスク - コードスタイル重大度との比較（C-19）
- 1: 中リスク - エラーハンドリングに関する主張（C-20）：実装詳細の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 重大度オプションが5つであることをViewModelで確認
- [ ] インデックスからReportDiagnosticへの変換が正しいことを確認
- [ ] Disabled（Suppress）がサポートされている理由を確認
- [ ] EditorConfigファイルへの書き込み時のエラーハンドリングを確認
- [ ] 不正インデックス時のInvalidOperationExceptionの動作を確認
