---
generated_at: 2026-02-10 14:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-命名スタイル場所コントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **LocationKindの完全な一覧**：EditorConfig、GlobalConfig以外のLocationKindの確認
  2. **パス表示のフォーマット**：絶対パスか相対パスかの確認
  3. **メモリリーク対策**：イベント購読解除の実装確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesLocationControl.xaml` (行1-16)
- E-02: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/View/ColumnViews/NamingStylesLocationControl.xaml.cs` (行1-20)
- E-03: `src/VisualStudio/Core/Def/EditorConfigSettings/NamingStyle/ViewModel/ColumnViewModels/NamingStylesLocationViewModel.cs` (行1-48)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行48)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行57)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 命名スタイル場所コントロールはUserControlとして実装されている | E-01 (行1) | ○ |
| C-02 | Labelを使用して場所情報を表示する | E-01 (行11-14) | ○ |
| C-03 | ContentプロパティにLocationValueがバインドされる | E-01 (行12) | ○ |
| C-04 | ToolTipプロパティにLocationToolTipがバインドされる | E-01 (行13) | ○ |
| C-05 | AutomationProperties.NameにLocationAutomationNameがバインドされる | E-01 (行14) | ○ |
| C-06 | ViewModelはNamingStylesLocationViewModelクラスである | E-01 (行7), E-02 (行15) | ○ |
| C-07 | 本コントロールは読み取り専用である | E-01, E-02 (編集機能なし) | ○ |
| C-08 | ViewModelはNotifyPropertyChangedBaseを継承している | E-03 (行11) | ○ |
| C-09 | GetLocationStringメソッドで場所情報を文字列に変換する | E-03 (行42-47) | ○ |
| C-10 | LocationKind.EditorConfigの場合はパスを返す | E-03 (行45) | ○ |
| C-11 | LocationKind.GlobalConfigの場合はパスを返す | E-03 (行45) | ○ |
| C-12 | その他の場合は"Visual Studio Settings"を返す | E-03 (行46) | ○ |
| C-13 | SettingChangedイベントを購読している | E-03 (行19) | ○ |
| C-14 | OnSettingChangedでLocationValueが更新される | E-03 (行39-40) | ○ |
| C-15 | LocationToolTipは"Location"を返す静的プロパティである | E-03 (行36) | ○ |
| C-16 | LocationAutomationNameは"Location"を返す静的プロパティである | E-03 (行37) | ○ |
| C-17 | 関連機能は116（コードスタイル分析）である | E-05 | ○ |
| C-18 | 画面カテゴリはEditorConfig設定 - 命名スタイルである | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての主張に根拠が存在します

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI構造に関する主張（C-01〜C-07）
- 0: 低リスク - ViewModel実装に関する主張（C-08〜C-16）
- 0: 低リスク - メタ情報に関する主張（C-17, C-18）

## 6) レビュアーチェックリスト（最小）
- [ ] Labelのバインディング設定がXAMLとViewModelで一致することを確認
- [ ] GetLocationStringメソッドがLocationKindに応じて正しく変換することを確認
- [ ] SettingChangedイベントの購読と購読解除が適切に行われていることを確認
- [ ] LocationValueのnullチェックロジックが正しいことを確認
- [ ] "Visual Studio Settings"文字列がリソースファイルから取得されていることを確認
