---
generated_at: 2026-02-10 14:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：49-重大度コントロール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **EditorConfigファイル読み取り専用時の挙動**：エラーハンドリングの詳細確認が必要
  2. **IsNotConfigurableルールの実際のUI動作**：グレーアウト表示の確認
  3. **変更チェックのロジック**：同値選択時の処理確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/SeverityControl.xaml` (行1-19)
- E-02: `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/View/SeverityControl.xaml.cs` (行1-26)
- E-03: `src/VisualStudio/Core/Def/EditorConfigSettings/Analyzers/ViewModel/SeverityViewModel.cs` (行1-83)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行50)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行60)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 重大度コントロールはUserControlとして実装されている | E-01 (行1) | ○ |
| C-02 | ComboBoxを使用してドロップダウン選択を提供する | E-01 (行11-17) | ○ |
| C-03 | ItemsSourceにSeveritiesがバインドされる | E-01 (行12) | ○ |
| C-04 | SelectedValueにSelectedSeverityValueがバインドされる | E-01 (行13) | ○ |
| C-05 | IsEnabledにIsConfigurableがバインドされる | E-01 (行14) | ○ |
| C-06 | ToolTipプロパティがバインドされている | E-01 (行15) | ○ |
| C-07 | AutomationProperties.Nameがバインドされている | E-01 (行16) | ○ |
| C-08 | SelectionChangedイベントでViewModelに通知する | E-01 (行17), E-02 (行24-25) | ○ |
| C-09 | ViewModelはSeverityViewModelクラスである | E-02 (行15, 17-22) | ○ |
| C-10 | 重大度オプションは5つ（Disabled, Refactoring Only, Suggestion, Warning, Error）である | E-03 (行13-20) | ○ |
| C-11 | IsConfigurableは!setting.IsNotConfigurableで判定される | E-03 (行57) | ○ |
| C-12 | ToolTipはIsConfigurableに応じて変わる | E-03 (行59-61) | ○ |
| C-13 | コンストラクタで現在の重大度からインデックスに変換する | E-03 (行47-55) | ○ |
| C-14 | SelectionChangedメソッドはインデックスからReportDiagnosticに変換する | E-03 (行66-82) | ○ |
| C-15 | インデックス0はSuppress、1はHidden、2はInfo、3はWarn、4はErrorに対応する | E-03 (行68-75) | ○ |
| C-16 | 不正なインデックスでInvalidOperationExceptionがスローされる | E-03 (行75) | ○ |
| C-17 | 現在値と比較して変更がある場合のみChangeSeverityが呼び出される | E-03 (行78-81) | ○ |
| C-18 | ThemedDialogスタイルを使用している | E-01 (行7) | ○ |
| C-19 | AutomationNameは"Severity"を返す | E-03 (行43) | ○ |
| C-20 | 関連機能は66（診断エンジン）である | E-05 | ○ |
| C-21 | 画面カテゴリはEditorConfig設定 - アナライザーである | E-04 | ○ |
| C-22 | 設定不可のルールではツールチップに"This rule is not configurable"が表示される | E-03 (行61) | ○ |
| C-23 | 設定可能なルールではツールチップに"Severity"が表示される | E-03 (行60) | ○ |
| C-24 | EditorConfigファイルが読み取り専用の場合は変更が反映されない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24について：EditorConfigファイルが読み取り専用の場合のエラーハンドリングに関するコードが確認できませんでした
  - 候補：AnalyzerSetting.ChangeSeverity / EditorTextUpdater.cs / Visual Studioファイル書き込みAPI

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - UI構造とバインディングに関する主張（C-01〜C-09, C-18）
- 0: 低リスク - ViewModel実装に関する主張（C-10〜C-17, C-19）
- 0: 低リスク - 設定可否制御に関する主張（C-11, C-12, C-22, C-23）
- 1: 中リスク - エラーハンドリングに関する主張（C-24）：実装詳細の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 重大度オプションが5つであることをViewModelで確認
- [ ] IsConfigurableによるComboBoxの有効/無効制御が正しく機能することを確認
- [ ] ツールチップが設定可否に応じて正しく変わることを確認
- [ ] インデックスからReportDiagnosticへの変換が正しいことを確認
- [ ] 変更チェックロジック（現在値との比較）が正しく機能することを確認
- [ ] EditorConfigファイルへの書き込み時のエラーハンドリングを確認
