---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-インターフェース抽出ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/ExtractInterface/ExtractInterfaceDialog.xaml` (行1-84)
- E-02: `src/VisualStudio/Core/Def/ExtractInterface/ExtractInterfaceDialog.xaml.cs` (行1-82)
- E-03: `src/VisualStudio/Core/Def/CommonControls/NewTypeDestinationSelection.xaml` (行1-108)
- E-04: `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml` (行1-202)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (行6)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行8-9)
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` (行38, 53-54)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クラスからインターフェースを抽出する | E-05 | ○ |
| C-02 | パブリックメンバーの選択 | E-05, E-06 | ○ |
| C-03 | ヘルプトピックはvs.csharp.refactoring.extractinterface | E-02 行34 | ○ |
| C-04 | ダイアログサイズ460x460、最小460x460 | E-01 行15-16 | ○ |
| C-05 | リサイズ可能（CanResizeWithGrip） | E-01 行20 | ○ |
| C-06 | HasHelpButton=True | E-01 行18 | ○ |
| C-07 | NewTypeDestinationSelectionコントロールを使用 | E-01 行49 | ○ |
| C-08 | MemberSelectionコントロールを使用 | E-02 行37, E-01 行58 | ○ |
| C-09 | パブリックメンバーのみが対象（Header表示） | E-01 行56 SelectPublicMembersToFormInterface | ○ |
| C-10 | OK/Cancelボタン | E-01 行60-82 | ○ |
| C-11 | VSThemeDictionary.xaml参照 | E-01 行27-29 | ○ |
| C-12 | OK_ClickでTrySubmit実行 | E-02 行45-51 | ○ |
| C-13 | TestAccessorでSelectAll/DeselectAllボタン参照 | E-02 行70-72 | ○ |
| C-14 | TestAccessorでDestinationラジオボタン参照 | E-02 行74-76 | ○ |
| C-15 | TestAccessorでファイル名TextBox参照 | E-02 行78 | ○ |
| C-16 | TestAccessorでMembersDataGrid参照 | E-02 行80 | ○ |
| C-17 | EnumBoolConverterを使用 | E-01 行39 | ○ |
| C-18 | 機能マッピングとの整合性（インターフェース抽出が主機能） | E-06 行8 | ○ |
| C-19 | 画面遷移図との整合性 | E-07 | ○ |
| C-20 | FocusManager.FocusedElementでinterfaceNameTextBoxにフォーカス | E-01 行19 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - クラス抽出ダイアログと類似の構造
- 0: 低リスク - 共通コントロールを使用

## 6) レビュアーチェックリスト（最小）

- [ ] パブリックメンバーのみ表示される仕様は正確か
- [ ] クラス抽出ダイアログとの違いを理解しているか
- [ ] 画面遷移図との整合性を確認したか
