---
generated_at: 2026-02-10 13:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：51-タブコントロールスタイル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **SettingsEditorControlでの参照方法**：実際の参照コードを確認する必要あり
  2. **VS2017以降の要件**：明示的なドキュメントなし
  3. **他の画面からの参照**：具体的な参照箇所の特定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/EditorConfigSettings/Styles/TabControlStyles.xaml` 1-61行目
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` 52行目
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 62行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TabControlに対してVSダイアログスタイルを継承 | E-01 7行目 | ○ |
| C-02 | TabItemにカスタムテンプレートを定義 | E-01 15-59行目 | ○ |
| C-03 | 選択状態でアンダーライン表示 | E-01 27-34行目, 41行目 | ○ |
| C-04 | Background=VsBrushes.BrandedUIBackgroundKey | E-01 10行目 | ○ |
| C-05 | FontSize=Environment122PercentFontSizeKey | E-01 11行目 | ○ |
| C-06 | Foreground=VsBrushes.BrandedUITextKey | E-01 12行目 | ○ |
| C-07 | Padding=20,0,20,0 | E-01 13行目 | ○ |
| C-08 | 選択時にInnerTabSelectedTextBrushKey適用 | E-01 42行目 | ○ |
| C-09 | フォーカス時にInnerTabTextFocusedBrushKey適用 | E-01 48行目 | ○ |
| C-10 | ホバー時にInnerTabTextHoverBrushKey適用 | E-01 54行目 | ○ |
| C-11 | アンダーライン高さ3px | E-01 30行目 | ○ |
| C-12 | VS2017以降のバージョンが必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- VS2017以降の要件に関する明示的なドキュメントがない
  - 候補：Microsoft.VisualStudio.Shell.15.0 の公式ドキュメント / NuGetパッケージ情報 / プロジェクトのターゲットフレームワーク設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - リソースディクショナリのため、コードロジックによるバグリスクは低い
- 1: 中リスク - テーマ連動が正しく機能するかは実行環境での確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] TabControlStyles.xamlのXAML構文が正しいことを確認
- [ ] SettingsEditorControl.xamlからの参照が正しく行われているか確認
- [ ] ライトテーマ・ダークテーマ両方でスタイルが正しく適用されるか確認
