---
generated_at: 2026-02-10 13:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：52-詳細エラー情報ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張にコードベースの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/ErrorReporting/DetailedErrorInfoDialog.xaml` 1-50行目
- E-02: `src/VisualStudio/Core/Def/ErrorReporting/DetailedErrorInfoDialog.xaml.cs` 1-41行目
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 53行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 63行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ダイアログはDialogWindowを継承 | E-01 1行目, E-02 12行目 | ○ |
| C-02 | コンストラクタでtitleとerrorInfoを受け取る | E-02 16-17行目 | ○ |
| C-03 | TextBoxにerrorInfoを表示 | E-02 21行目 | ○ |
| C-04 | Copy to Clipboardボタンが存在 | E-01 37-41行目 | ○ |
| C-05 | Closeボタンが存在 | E-01 42-46行目 | ○ |
| C-06 | CopyMessageToClipBoardでクリップボードにコピー | E-02 26-36行目 | ○ |
| C-07 | CloseWindowでダイアログを閉じる | E-02 38-39行目 | ○ |
| C-08 | 例外発生時は無視（RDPセッション対応） | E-02 32-35行目 | ○ |
| C-09 | WindowStartupLocation=CenterOwner | E-01 13行目 | ○ |
| C-10 | ShowInTaskbar=False | E-01 12行目 | ○ |
| C-11 | MinWidth=300, MinHeight=300 | E-01 19-20行目 | ○ |
| C-12 | Width=768 | E-01 18行目 | ○ |
| C-13 | SizeToContent=Height | E-01 17行目 | ○ |
| C-14 | ボタンラベルはServicesVSResourcesから取得 | E-02 22-23行目 | ○ |
| C-15 | ScrollViewerでスクロール可能 | E-01 26-34行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張にコードベースの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなダイアログで、機能も限定的
- 0: 低リスク - クリップボードコピーの例外ハンドリングも実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] ダイアログが正しく表示されることを確認（サイズ、位置）
- [ ] Copy to Clipboardボタンでエラー情報が正しくコピーされることを確認
- [ ] Closeボタンでダイアログが閉じることを確認
- [ ] 長いスタックトレースでスクロールが正しく機能することを確認
