---
generated_at: 2026-02-10 13:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-継承マージンコンテキストメニュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張にコードベースの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/InheritanceMarginContextMenu.xaml` 1-309行目
- E-02: `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/InheritanceMarginContextMenu.xaml.cs` 1-85行目
- E-03: `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/TargetMenuItemViewModel.cs` 1-37行目
- E-04: `src/VisualStudio/Core/Def/InheritanceMargin/MarginGlyph/MenuItemContainerTemplateSelector.cs` 1-45行目
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` 54行目
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 64行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ContextMenuをクリックで表示 | E-01 1行目 | ○ |
| C-02 | HeaderMenuItemViewModelでヘッダー表示 | E-01 248-250行目, E-04 18-21行目 | ○ |
| C-03 | MemberMenuItemViewModelでメンバー表示 | E-01 254-256行目, E-04 36-40行目 | ○ |
| C-04 | TargetMenuItemViewModelでターゲット表示 | E-01 260-262行目, E-04 30-34行目 | ○ |
| C-05 | DisambiguousTargetMenuItemViewModelで言語区別ターゲット表示 | E-01 266-268行目, E-04 24-28行目 | ○ |
| C-06 | DefinitionItemでナビゲーション | E-03 20行目, E-02 68行目 | ○ |
| C-07 | TargetMenuItem_OnClickでナビゲーション実行 | E-02 48-57行目 | ○ |
| C-08 | TryRehydrateAsyncで情報復元 | E-02 68行目 | ○ |
| C-09 | TryPresentLocationOrNavigateIfOneAsyncで移動 | E-02 72-77行目 | ○ |
| C-10 | InheritanceMarginLoggerでログ記録 | E-02 52行目, 82行目 | ○ |
| C-11 | MaxHeight=400 | E-01 14行目 | ○ |
| C-12 | StaysOpen=True | E-01 15行目 | ○ |
| C-13 | DPIスケーリング対応（ScaleTransform） | E-02 44-45行目 | ○ |
| C-14 | スクロールビューアー使用 | E-01 294-300行目 | ○ |
| C-15 | コマンドバースタイル使用 | E-01 17行目 | ○ |
| C-16 | CrispImageでアイコン表示 | E-01 25行目 | ○ |
| C-17 | IUIThreadOperationExecutorで操作実行 | E-02 61-65行目 | ○ |
| C-18 | IStreamingFindUsagesPresenterでナビゲーション | E-02 72-77行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張にコードベースの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なWPFコンテキストメニュー実装
- 1: 中リスク - 非同期ナビゲーション処理のエラーハンドリング

## 6) レビュアーチェックリスト（最小）
- [ ] 継承マージングリフクリック時にメニューが正しく表示されることを確認
- [ ] ヘッダー、メンバー、ターゲット各項目が正しくスタイリングされることを確認
- [ ] ターゲット項目クリック時に正しい位置へナビゲートすることを確認
- [ ] 異なる言語からの継承時に言語アイコンが表示されることを確認
- [ ] 大量の継承項目がある場合のスクロール動作を確認
