---
generated_at: 2026-02-10 13:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-ステータスインジケーター

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張にコードベースの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/StatusIndicator.xaml` 1-30行目
- E-02: `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/StatusIndicator.xaml.cs` 1-71行目
- E-03: `src/VisualStudio/VisualStudioDiagnosticsToolWindow/PerfMargin/ActivityLevel.cs` 1-93行目
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` 56行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 66行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UserControlとして実装 | E-01 1行目, E-02 18行目 | ○ |
| C-02 | コンストラクタでActivityLevelを受け取る | E-02 23-29行目 | ○ |
| C-03 | バーグラフ幅30px、高さ8px | E-01 13行目 | ○ |
| C-04 | 開始色#FFC4FF00、終了色Red | E-01 23-24行目 | ○ |
| C-05 | ScaleTransformでクリッピング制御 | E-01 17行目, E-02 61行目 | ○ |
| C-06 | アクティブ時1秒でスケール1.0に | E-02 48行目 | ○ |
| C-07 | 非アクティブ時0.33秒でスケール0.0に | E-02 49行目 | ○ |
| C-08 | MinimumScale=0.2 | E-02 47行目, 65行目 | ○ |
| C-09 | FillBehavior.HoldEnd | E-02 48-49行目 | ○ |
| C-10 | WPFバインディング不使用の理由（メモリ最適化） | E-02 31行目コメント | ○ |
| C-11 | Subscribe/Unsubscribeでイベント管理 | E-02 32-40行目 | ○ |
| C-12 | _changedSinceLastUpdateフラグ使用 | E-02 21行目, 44行目, 53-58行目 | ○ |
| C-13 | 静的アニメーションオブジェクト共有 | E-02 48-49行目 | ○ |
| C-14 | ActivityLevel.IsActiveChanged イベント | E-03 44行目, E-02 34行目 | ○ |
| C-15 | ActivityLevel.IsActive参照カウント方式 | E-03 48-49行目 | ○ |
| C-16 | ActivityLevel親子関係 | E-03 24-36行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張にコードベースの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなアニメーションコントロール
- 1: 中リスク - 高頻度更新のパフォーマンスへの影響

## 6) レビュアーチェックリスト（最小）
- [ ] アクティビティ開始時にバーが伸びることを確認
- [ ] アクティビティ終了時にバーが縮むことを確認
- [ ] 高頻度の状態変更時にアニメーションが適切に動作することを確認
- [ ] メモリリークがないことを確認（Subscribe/Unsubscribeの対称性）
