---
generated_at: 2026-02-10 13:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-プロジェクションバッファマージン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張にコードベースの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionBufferMargin.xaml` 1-59行目
- E-02: `src/VisualStudio/VisualStudioDiagnosticsToolWindow/VenusMargin/ProjectionBufferMargin.xaml.cs` 1-69行目
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 57行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 67行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UserControlとして実装 | E-01 2行目, E-02 18行目 | ○ |
| C-02 | TextViewとTextEditorFactoryプロパティを持つ | E-02 22-23行目 | ○ |
| C-03 | SourceBuffersへのバインディング | E-01 21行目 | ○ |
| C-04 | SourceSpansへのバインディング | E-01 35行目 | ○ |
| C-05 | バッファメニューでドロップダウン表示 | E-01 18-31行目 | ○ |
| C-06 | ContentTypeをボタン表示 | E-01 25行目 | ○ |
| C-07 | ListView水平配置 | E-01 38-42行目 | ○ |
| C-08 | Button_Clickで新規ウィンドウ作成 | E-02 41-67行目 | ○ |
| C-09 | CreateTextViewでビュー作成 | E-02 45行目 | ○ |
| C-10 | CreateTextViewHostでホスト作成 | E-02 53行目 | ○ |
| C-11 | Window.Closedでホスト破棄 | E-02 61-64行目 | ○ |
| C-12 | ListView_SelectionChangedでスパン選択処理 | E-02 30-34行目 | ○ |
| C-13 | ProjectionSpanTaggerProvider.PropertyName使用 | E-02 32行目 | ○ |
| C-14 | SelectionChanged静的イベント発火 | E-02 20行目, 33行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべての主張にコードベースの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 診断専用ツールで本番影響なし
- 1: 中リスク - ウィンドウ管理とメモリリーク防止

## 6) レビュアーチェックリスト（最小）
- [ ] プロジェクションバッファ使用時にマージンが正しく表示されることを確認
- [ ] ソースバッファ一覧が正しく表示されることを確認
- [ ] スパン選択時にハイライトが正しく表示されることを確認
- [ ] バッファボタンクリック時に新規ウィンドウが正しく表示されることを確認
- [ ] ウィンドウクローズ時にリソースが正しく解放されることを確認
