---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-名前空間移動ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialog.xaml` (行1-116)
- E-02: `src/VisualStudio/Core/Def/MoveToNamespace/MoveToNamespaceDialog.xaml.cs` (行1-61)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行7)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行10)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (行39, 55)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 型を別の名前空間に移動する | E-03 | ○ |
| C-02 | 移動先名前空間の入力または選択 | E-01 行45-73 | ○ |
| C-03 | ダイアログサイズ400x166、最小400x166 | E-01 行14-15 | ○ |
| C-04 | リサイズ可能（CanResizeWithGrip） | E-01 行17 | ○ |
| C-05 | ThemedDialogStyleLoaderでデフォルトスタイル適用 | E-01 行21 | ○ |
| C-06 | 編集可能ComboBox（IsEditable=True） | E-01 行47 | ○ |
| C-07 | 候補リストをドロップダウンで表示 | E-01 行51 | ○ |
| C-08 | MaxDropDownHeight=200 | E-01 行54 | ○ |
| C-09 | 履歴アイコン（KnownMonikers.History）表示 | E-01 行63-67 | ○ |
| C-10 | メッセージ表示エリア | E-01 行77-91 | ○ |
| C-11 | メッセージアイコン（CrispImage） | E-01 行81-85 | ○ |
| C-12 | メッセージテキスト（LiveTextBlock） | E-01 行87-90 | ○ |
| C-13 | OK/Cancelボタン | E-01 行94-114 | ○ |
| C-14 | CanSubmitでOKボタン有効/無効制御 | E-01 行105, E-02 行44 | ○ |
| C-15 | ロード完了時にフォーカス移動 | E-02 行31 | ○ |
| C-16 | BooleanToVisibilityConverterでメッセージ表示制御 | E-01 行30 | ○ |
| C-17 | 機能マッピングとの整合性（名前空間移動が主機能） | E-04 | ○ |
| C-18 | 画面遷移図との整合性 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - シンプルな入力ダイアログ
- 0: 低リスク - バリデーション結果の表示が明確

## 6) レビュアーチェックリスト（最小）

- [ ] 履歴機能の仕様は正確か
- [ ] バリデーションメッセージの一覧は網羅的か
- [ ] 画面遷移図との整合性を確認したか
