---
generated_at: 2026-02-10 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-メンバー引き上げダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialog.xaml` (行1-167)
- E-02: `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialog.xaml.cs` (行1-76)
- E-03: `src/VisualStudio/Core/Def/CommonControls/MemberSelection.xaml` (行1-202)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行8)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行11-12)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (行40, 56-57)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メンバーを基底クラスまたはインターフェースに引き上げる | E-04 | ○ |
| C-02 | TreeViewで基底型階層を選択 | E-01 行77-127 | ○ |
| C-03 | ダイアログサイズ500x498、最小510x498 | E-01 行18-21 | ○ |
| C-04 | リサイズ可能（CanResizeWithGrip） | E-01 行24 | ○ |
| C-05 | MemberSelectionコントロールを使用 | E-02 行36, E-01 行137 | ○ |
| C-06 | 説明ラベル（Description） | E-01 行64-69 | ○ |
| C-07 | OK/Cancelボタン | E-01 行139-165 | ○ |
| C-08 | OkButtonEnabled でOKボタン制御 | E-01 行150 | ○ |
| C-09 | TreeViewItemStyleでIsExpanded=True | E-01 行41 | ○ |
| C-10 | 選択時にFontWeight="Bold" | E-01 行51 | ○ |
| C-11 | ThemedImageSourceConverterでアイコン表示 | E-01 行54, 102-110 | ○ |
| C-12 | SymbolNameとNamespaceをToolTipで表示 | E-01 行114-115 | ○ |
| C-13 | HierarchicalDataTemplateで子ノード表示 | E-01 行89-126 | ○ |
| C-14 | Destination_SelectedItemChangedで選択更新 | E-02 行69-75 | ○ |
| C-15 | OKButton_ClickでCreatePullMemberUpOptions呼び出し | E-02 行44-58 | ○ |
| C-16 | PullUpOperationNeedsToDoExtraChangesで警告判定 | E-02 行47 | ○ |
| C-17 | ShowWarningDialogで警告ダイアログ表示 | E-02 行60-65 | ○ |
| C-18 | VSThemeDictionary.xaml参照 | E-01 行30-32 | ○ |
| C-19 | VsBrushes.ToolWindowTextKeyで文字色設定 | E-01 行119 | ○ |
| C-20 | 機能マッピングとの整合性（メンバー引き上げが主機能） | E-05 行11 | ○ |
| C-21 | 画面遷移図との整合性（警告ダイアログへ遷移） | E-06 | ○ |
| C-22 | ImageThemingUtilitiesでテーマ対応 | E-01 行27, 99-100 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - TreeViewとMemberSelectionの組み合わせ
- 0: 低リスク - 警告ダイアログへの遷移条件は明確

## 6) レビュアーチェックリスト（最小）

- [ ] TreeViewの階層表示仕様は正確か
- [ ] 警告ダイアログ表示条件を理解しているか
- [ ] 画面遷移図との整合性を確認したか
