---
generated_at: 2026-02-10 11:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-メンバー引き上げ警告ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningDialog.xaml` (行1-87)
- E-02: `src/VisualStudio/Core/Def/PullMemberUp/WarningDialog/PullMemberUpWarningDialog.xaml.cs` (行1-38)
- E-03: `src/VisualStudio/Core/Def/PullMemberUp/MainDialog/PullMemberUpDialog.xaml.cs` (行60-65)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行9)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行13)
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` (行41, 46-47)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 追加変更が必要な場合に表示される警告ダイアログ | E-04, E-03 | ○ |
| C-02 | ダイアログサイズ533x390、最小533x390 | E-01 行16-18 | ○ |
| C-03 | SizeToContent="WidthAndHeight" | E-01 行13 | ○ |
| C-04 | リサイズ可能（CanResizeWithGrip） | E-01 行21 | ○ |
| C-05 | ProblemsGroupBoxで問題一覧を表示 | E-01 行33-60 | ○ |
| C-06 | ListViewで警告メッセージ一覧 | E-01 行41-59 | ○ |
| C-07 | ScrollViewer.VerticalScrollBarVisibility="Auto" | E-01 行45 | ○ |
| C-08 | SelectionMode="Single" | E-01 行48 | ○ |
| C-09 | WrapPanelでTextBlockラップ | E-01 行51-52 | ○ |
| C-10 | Finish/Backボタン | E-01 行61-85 | ○ |
| C-11 | FinishButton_ClickでLogger.Log呼び出し | E-02 行27-31 | ○ |
| C-12 | BackButton_ClickでLogger.Log呼び出し | E-02 行33-37 | ○ |
| C-13 | FunctionId.PullMembersUpWarning_UserProceedToFinish | E-02 行29 | ○ |
| C-14 | FunctionId.PullMembersUpWarning_UserGoBack | E-02 行35 | ○ |
| C-15 | 機能マッピングとの整合性 | E-05 | ○ |
| C-16 | 画面遷移図との整合性（PMDから遷移、Back時戻り） | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - シンプルな警告確認ダイアログ
- 0: 低リスク - テレメトリログが正確に記録される

## 6) レビュアーチェックリスト（最小）

- [ ] 警告メッセージの内容は網羅的か
- [ ] 親ダイアログへの戻りフローは正確か
- [ ] 画面遷移図との整合性を確認したか
