---
generated_at: 2026-02-10 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-メンバー選択ダイアログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/VisualStudio/Core/Def/PickMembers/PickMembersDialog.xaml` (行1-208)
- E-02: `src/VisualStudio/Core/Def/PickMembers/PickMembersDialog.xaml.cs` (行1-171)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行10)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行14)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (行42)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 汎用的なメンバー選択ダイアログ | E-03, E-04 | ○ |
| C-02 | ダイアログサイズ460x380、最小460x380 | E-01 行18-20 | ○ |
| C-03 | リサイズ可能（CanResizeWithGrip） | E-01 行24 | ○ |
| C-04 | HasHelpButton=True | E-01 行22 | ○ |
| C-05 | ThemedDialogStyleLoader適用 | E-01 行28 | ○ |
| C-06 | InputBindingsでAlt+Up/Down定義 | E-01 行52-53 | ○ |
| C-07 | SearchTextBoxで検索 | E-01 行61-65, E-02 行65-69 | ○ |
| C-08 | AutomationDelegatingListView使用 | E-01 行80 | ○ |
| C-09 | メンバーチェックボックス | E-01 行94-100 | ○ |
| C-10 | メンバーアイコン表示 | E-01 行101-116 | ○ |
| C-11 | 上移動ボタン（KnownMonikers.MoveUp） | E-01 行126-137 | ○ |
| C-12 | 下移動ボタン（KnownMonikers.MoveDown） | E-01 行138-150 | ○ |
| C-13 | Select All/Deselect Allボタン | E-01 行152-165 | ○ |
| C-14 | Options（ItemsControl + CheckBox） | E-01 行167-181 | ○ |
| C-15 | OK/Cancelボタン | E-01 行184-206 | ○ |
| C-16 | Alt+Sで全選択 | E-02 行50-55 | ○ |
| C-17 | Alt+Dで全解除 | E-02 行57-62 | ○ |
| C-18 | MoveUp_ClickでItems.Refresh | E-02 行83-94 | ○ |
| C-19 | MoveDown_ClickでItems.Refresh | E-02 行96-107 | ○ |
| C-20 | スペースキーでトグル | E-02 行123-130 | ○ |
| C-21 | ダブルクリックでトグル | E-02 行132-139 | ○ |
| C-22 | Filter()でメンバー検索 | E-02 行65-69 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 汎用コンポーネントとして設計が明確
- 0: 低リスク - キーボードショートカットの一覧が完全

## 6) レビュアーチェックリスト（最小）

- [ ] キーボードショートカットの一覧は正確か
- [ ] オプション機能の仕様は理解しているか
- [ ] 画面遷移図との整合性を確認したか
