---
generated_at: 2026-02-10 15:30:00
metrics:
  claims_total: 40
  claims_with_evidence: 32
  claims_without_evidence: 8
confidence_derived: 0.80
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：32 / 40、根拠なし：8
- 優先レビュー（高）
  1. **IT-031 (Brokered Service連携)**: 実装コードは確認したが、統合テストコードの直接確認ができていない
  2. **IT-032, IT-033 (テスト実行連携)**: テストアダプター連携の詳細仕様が外部依存
  3. **IT-036 (Razor連携)**: Razor固有の初期化シーケンスの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/VisualStudio/IntegrationTest/New.IntegrationTests/CSharp/CSharpGoToDefinition.cs`
- E-02: `src/VisualStudio/IntegrationTest/New.IntegrationTests/CSharp/CSharpBuild.cs`
- E-03: `src/VisualStudio/IntegrationTest/New.IntegrationTests/CSharp/CSharpCodeActions.cs`
- E-04: `src/Compilers/Core/MSBuildTaskTests/IntegrationTests.cs`
- E-05: `src/VisualStudio/IntegrationTest/New.IntegrationTests/AbstractIntegrationTest.cs`
- E-06: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/LanguageServer/LanguageServerHost.cs`
- E-07: `src/LanguageServer/Protocol/Handler/` (各種LSPハンドラー)
- E-08: `src/LanguageServer/ProtocolUnitTests/` (LSPプロトコルテスト群)
- E-09: `src/Workspaces/CoreTest/` (ワークスペーステスト群)
- E-10: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/LanguageServerProjectSystem.cs`
- E-11: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/TestDiscoverer.cs`
- E-12: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Testing/TestRunner.cs`
- E-13: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/BrokeredServices/ServiceBrokerConnectHandler.cs`
- E-14: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/HostWorkspace/Razor/RazorInitializer.cs`
- E-15: `azure-pipelines-integration.yml` (結合テストパイプライン定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GoToDefinition - クラス定義遷移テスト | E-01 | ○ |
| C-02 | GoToDefinition - プロビジョナルタブ動作 | E-01 | ○ |
| C-03 | GoToDefinition - 複数定義結果 | E-01 | ○ |
| C-04 | GoToDefinition - メタデータナビゲーション | E-01 | ○ |
| C-05 | C#プロジェクトビルドテスト | E-02 | ○ |
| C-06 | コマンドラインビルドテスト | E-02 | ○ |
| C-07 | MSBuildプロジェクト参照テスト | E-04 | ○ |
| C-08 | 閉じているファイルへのメソッド生成 | E-03 | ○ |
| C-09 | using追加の優先順位 | E-03 | ○ |
| C-10 | EditorConfig適用とFix All | E-03 | ○ |
| C-11 | EditorConfig設定変更の動的反映 | E-03 | ○ |
| C-12 | Fix All - 生成コード除外 | E-03 | ○ |
| C-13 | IntelliSense分類表示 | E-03 | ○ |
| C-14 | LSP初期化テスト | E-06, E-08 | ○ |
| C-15 | LSP補完機能テスト | E-08 | ○ |
| C-16 | LSPホバー情報テスト | E-08 | ○ |
| C-17 | LSP参照検索テスト | E-08 | ○ |
| C-18 | LSPリネームテスト | E-08 | ○ |
| C-19 | プロジェクト読み込みテスト | E-09, E-10 | ○ |
| C-20 | ファイル変更監視テスト | E-10 | ○ |
| C-21 | カスタムアナライザー読み込み | E-05 | ○ |
| C-22 | NuGetパッケージ復元 | E-02, E-05 | ○ |
| C-23 | デバッグ構成取得 | E-07 | ○ |
| C-24 | Fix All - コンテナメンバスコープ | E-03 | ○ |
| C-25 | Fix All - コンテナ型スコープ | E-03 | ○ |
| C-26 | FindReferencesウィンドウ連携 | E-01 | ○ |
| C-27 | コード折りたたみ - メタデータドキュメント | E-01 | ○ |
| C-28 | ソースジェネレーター出力 | **根拠不足** | △ |
| C-29 | ビルドエラー表示 | E-02 | ○ |
| C-30 | 診断重大度変更 | E-03 | ○ |
| C-31 | Service Broker接続 | E-13 | △ |
| C-32 | テストディスカバリー | E-11 | △ |
| C-33 | テスト実行 | E-12 | △ |
| C-34 | LSP署名ヘルプ | E-08 | ○ |
| C-35 | LSPセマンティックトークン | E-08 | ○ |
| C-36 | Razor初期化 | E-14 | △ |
| C-37 | 文字列変換リファクタリング | E-03 | ○ |
| C-38 | ドキュメントフォーマット | E-08 | ○ |
| C-39 | インラインヒント | **根拠不足** | △ |
| C-40 | 拡張アセンブリ読み込み | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **ソースジェネレーター結合テスト (C-28)**: 実装コードは存在するが、結合テストとしての検証シナリオが明示的に記述されたテストファイルが見つからない
  - 候補：src/VisualStudio/IntegrationTest/New.IntegrationTests/CSharp/CSharpSourceGenerators.cs / 関連ドキュメント
- **Service Broker詳細仕様 (C-31)**: BrokeredServiceの詳細な統合テストシナリオが外部仕様に依存
  - 候補：Microsoft.ServiceHub.Framework ドキュメント / 外部仕様書
- **テストアダプター連携 (C-32, C-33)**: vstest.console連携の詳細がVS Test Platform仕様に依存
  - 候補：Microsoft.TestPlatform ドキュメント / TestAdapter仕様
- **Razor連携詳細 (C-36)**: Razor Language Serverの初期化シーケンスが別リポジトリで管理
  - 候補：dotnet/razor リポジトリ / Razor仕様書
- **インラインヒント統合テスト (C-39)**: LSP InlayHint機能の結合テストシナリオが限定的
  - 候補：src/LanguageServer/ProtocolUnitTests/InlayHint/
- **拡張アセンブリ読み込み (C-40)**: ExtensionAssemblyManagerの統合テストシナリオが不明確
  - 候補：拡張機能開発ドキュメント

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - ソースジェネレーター連携 (IT-028): 機能は実装されているが統合テストの網羅性要確認
- **1: 中リスク** - Service Broker連携 (IT-031): 外部サービス依存のため環境依存テストの可能性
- **1: 中リスク** - テスト実行連携 (IT-032, IT-033): テストプラットフォームバージョン依存
- **0: 低リスク** - Razor連携 (IT-036): 主要機能は安定、初期化シーケンスの確認のみ
- **0: 低リスク** - インラインヒント/拡張機能 (IT-039, IT-040): オプション機能のため優先度低

## 6) レビュアーチェックリスト（最小）
- [ ] IT-001〜IT-004: GoToDefinition結合テストのシナリオがソースコード(CSharpGoToDefinition.cs)と一致しているか
- [ ] IT-005〜IT-007: ビルド連携テストがCI/CDパイプライン(azure-pipelines-integration.yml)と整合しているか
- [ ] IT-008〜IT-013: コードアクション関連テストがCSharpCodeActions.csの実装と対応しているか
- [ ] IT-014〜IT-018, IT-034〜IT-035: LSPプロトコルテストがProtocolUnitTestsの構成と一致しているか
- [ ] IT-028: ソースジェネレーターの結合テストシナリオを追加確認
- [ ] IT-031〜IT-033: 外部サービス連携テストの環境前提条件を確認
- [ ] IT-036: Razor初期化の前提条件と依存関係を確認
- [ ] 全体: テストケースIDの重複がないか、優先度設定が適切か
