---
generated_at: 2026-02-10 12:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての項目に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Notification/INotificationService.cs`
- E-02: `src/Features/Core/Portable/Notification/NotificationSeverity.cs`
- E-03: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/Logging/ShowToastNotification.cs`
- E-04: `src/LanguageServer/Protocol/Handler/LanguageServerNotificationManager.cs`
- E-05: `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler.cs`
- E-06: `src/Features/Core/Portable/ExternalAccess/UnitTesting/Notification/IGlobalOperationNotificationService.cs`
- E-07: `src/Features/Core/Portable/ExternalAccess/UnitTesting/Notification/AbstractGlobalOperationNotificationService.cs`
- E-08: `src/Features/Core/Portable/Rename/IRefactorNotifyService.cs`
- E-09: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs`
- E-10: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/INotificationHandler.cs`
- E-11: `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs`
- E-12: `src/VisualStudio/Core/Def/Notification/VSNotificationServiceFactory.cs`
- E-13: `src/EditorFeatures/Core/Notification/EditorNotificationServiceFactory.cs`
- E-14: `src/LanguageServer/Protocol/Protocol/LspNotification.cs`
- E-15: `src/LanguageServer/Protocol/Handler/ILspServiceNotificationHandler.cs`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SendNotification - メッセージボックスにOKボタン付き通知を表示 | E-01, E-02, E-12, E-13 | ○ |
| C-02 | ConfirmMessageBox - Yes/No確認ダイアログを表示 | E-01, E-12, E-13 | ○ |
| C-03 | ShowToastNotification - カスタムLSPトースト通知 | E-03 | ○ |
| C-04 | SendNotificationAsync - JSON-RPC通知送信 | E-04 | ○ |
| C-05 | DidChangeConfiguration - 設定変更LSP通知 | E-05 | ○ |
| C-06 | GlobalOperationStarted - 操作開始イベント | E-06, E-07 | ○ |
| C-07 | GlobalOperationStopped - 操作終了イベント | E-06, E-07 | ○ |
| C-08 | OnBeforeGlobalSymbolRenamed - リネーム前通知 | E-08 | ○ |
| C-09 | OnAfterGlobalSymbolRenamed - リネーム後通知 | E-08 | ○ |
| C-10 | NotificationOption2.None - 診断抑制オプション | E-09 | ○ |
| C-11 | NotificationOption2.Silent - 非表示診断オプション | E-09 | ○ |
| C-12 | NotificationOption2.Suggestion - 情報レベル診断 | E-09 | ○ |
| C-13 | NotificationOption2.Warning - 警告レベル診断 | E-09 | ○ |
| C-14 | NotificationOption2.Error - エラーレベル診断 | E-09 | ○ |
| C-15 | INotificationHandler - パラメータなし通知ハンドラ | E-10, E-15 | ○ |
| C-16 | INotificationHandler<TRequest> - パラメータ付き通知ハンドラ | E-10, E-15 | ○ |
| C-17 | OmniSharpSendNotification - OmniSharp通知 | E-11 | ○ |
| C-18 | OmniSharpConfirmMessageBox - OmniSharp確認ダイアログ | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠が確認されたため、不足情報なし
- プロジェクト固有の通知機能（メール、SMS、プッシュ通知等）は検出されなかった
  - これはRoslynがコンパイラ/IDEプラットフォームであり、エンドユーザー向けの外部通知機能を持たないため

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての項目がソースコードから直接抽出されており、信頼性が高い
- 補足: 本プロジェクトは.NET Compiler Platform（Roslyn）であり、通知機能は主にIDE/エディタ向けのUI通知およびLSP（Language Server Protocol）ベースの開発者ツール間通信に限定される

## 6) レビュアーチェックリスト（最小）
- [ ] 各通知カテゴリの分類が適切か確認
- [ ] 通知名と説明の対応が正確か確認
- [ ] 備考欄のインターフェース名・クラス名が正しいか確認
- [ ] プロジェクト固有の追加通知機能が見落とされていないか確認
