# 通知設計書 1-SendNotification

## 概要

本ドキュメントは、Roslynプロジェクトにおける`SendNotification`通知メソッドの設計仕様を記載するものである。このメソッドは、Visual Studioエディタ環境においてユーザーへの情報通知を行うための基本的なメッセージボックス表示機能を提供する。

### 本通知の処理概要

`SendNotification`は、`INotificationService`インターフェースで定義されたメソッドであり、メッセージボックスにOKボタン付きの通知メッセージを表示する機能を提供する。Information、Warning、Errorの3種類の重大度（`NotificationSeverity`）をサポートし、ユーザーに対して適切なレベルの情報を視覚的に伝達することができる。

**業務上の目的・背景**：開発者がコードを編集・リファクタリングする際に、重要な情報や警告、エラーをユーザーに通知する必要がある。例えば、リネーム操作のキャンセル、抽出メソッドの失敗、スニペット展開時のエラーなど、ユーザーの操作に対するフィードバックを即座に提供することで、開発体験を向上させる。この通知機能は、IDE内での操作の成功・失敗・注意事項をユーザーに明確に伝える基盤となる。

**通知の送信タイミング**：コードアクション実行時、リファクタリング操作時、ナビゲーション機能の使用時など、ユーザーの操作に対する即時フィードバックが必要な場合に同期的に送信される。具体的には、GoToDefinition失敗時、ExtractMethod失敗時、ChangeSignature操作時、InlineRename開始時などで使用される。

**通知の受信者**：Visual StudioまたはWPFエディタを使用している開発者。通知は現在アクティブなIDEウィンドウに対してモーダルダイアログとして表示される。

**通知内容の概要**：操作の結果（成功、警告、エラー）を示すメッセージテキスト、オプションのタイトル、重大度に応じたアイコン（Information、Warning、Error）がメッセージボックスとして表示される。

**期待されるアクション**：ユーザーはメッセージを確認し、OKボタンをクリックしてダイアログを閉じる。通知の内容に応じて、ユーザーは後続の操作（コードの修正、設定の変更など）を行う判断を下す。

## 通知種別

アプリ内通知（モーダルメッセージボックス）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（モーダルダイアログとして表示） |
| リトライ | 無し（UIブロッキング操作のため） |

### 送信先決定ロジック

通知は常に現在のIDEインスタンスのアクティブウィンドウに対して表示される。特定のユーザーロールやプロジェクト設定による受信者のフィルタリングは行われない。

## 通知テンプレート

### メッセージボックス通知

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | モーダルメッセージボックス |
| ボタン構成 | OKボタンのみ |
| アイコン | 重大度に応じて変化（Info/Warning/Error） |

### 本文テンプレート

```
{message}
```

メッセージ内容は呼び出し元が動的に決定する。タイトルはオプションで、指定されない場合はシステムデフォルトまたは非表示。

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | メッセージボックス通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | 表示するメッセージ本文 | 呼び出し元から直接渡される | Yes |
| title | ダイアログのタイトル | 呼び出し元から直接渡される | No |
| severity | 通知の重大度 | NotificationSeverity列挙型 | No（デフォルト: Warning） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | GoToDefinition実行 | 定義が見つからない場合 | ナビゲーション失敗の通知 |
| 画面操作 | ExtractMethod実行 | 抽出可能なコードがない場合 | リファクタリング失敗の通知 |
| 画面操作 | ChangeSignature実行 | シグネチャ変更不可の場合 | 操作不可の通知 |
| 画面操作 | InlineRename開始 | リネーム対象が見つからない場合 | リネーム開始失敗の通知 |
| 画面操作 | EncapsulateField実行 | フィールドが選択されていない場合 | 操作対象不在の通知 |
| 画面操作 | ExtractInterface実行 | インターフェース抽出不可の場合 | 操作不可の通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| NotificationCallbackが設定されている場合 | テスト環境でコールバックが設定されている場合、実際のメッセージボックスは表示されずコールバックが呼ばれる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[呼び出し元がSendNotificationを呼び出し] --> B{NotificationCallbackが設定されているか?}
    B -->|Yes| C[コールバックを実行]
    B -->|No| D[UIモードをモーダルに設定]
    C --> I[終了]
    D --> E[SeverityをアイコンにマッピNG]
    E --> F[ShowMessageBoxを呼び出し]
    F --> G[ユーザーがOKをクリック]
    G --> H[UIモードを非モーダルに復元]
    H --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | データベースアクセスなし（純粋なUI操作） |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | データベースへの更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| UIシェル例外 | IVsUIShellサービスが利用できない場合 | finallyブロックでモーダル状態を解除し、UIがロックされることを防止 |
| パラメータ不正 | messageがnullの場合 | 呼び出し元で事前チェックが必要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（ユーザー操作起点のため） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

ユーザー操作に応じて即座に送信されるため、時間帯制限なし。

## セキュリティ考慮事項

- メッセージ内容にユーザーの入力値を含める場合、XSS対策は不要（ネイティブUI使用のため）
- 機密情報をメッセージに含めないよう呼び出し元で注意が必要
- テスト環境でのコールバック機能はプロダクション環境では使用しないこと

## 備考

- Visual Studio環境では`VSNotificationServiceFactory.VSDialogService`が実装を提供
- エディタ環境（WPF）では`EditorNotificationServiceFactory.EditorDialogService`が実装を提供
- テストではモックコールバックを使用して実際のUIを表示せずにテスト可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知に関連するインターフェースと列挙型の定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | INotificationService.cs | `src/Features/Core/Portable/Notification/INotificationService.cs` | INotificationServiceインターフェースの定義、SendNotificationとConfirmMessageBoxの2メソッドの契約を理解する |
| 1-2 | INotificationServiceCallback.cs | `src/Features/Core/Portable/Notification/INotificationServiceCallback.cs` | テスト用コールバックインターフェースの構造を理解する |

**読解のコツ**: `NotificationSeverity`列挙型（Information、Warning、Error）がメッセージボックスのアイコンにマッピングされることに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となる実装クラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VSNotificationServiceFactory.cs | `src/VisualStudio/Core/Def/Notification/VSNotificationServiceFactory.cs` | Visual Studio環境での実装。IVsUIShellを使用したメッセージボックス表示の実装詳細 |
| 2-2 | EditorNotificationServiceFactory.cs | `src/EditorFeatures/Core/Notification/EditorNotificationServiceFactory.cs` | WPFエディタ環境での実装。System.Windows.MessageBoxを使用 |

**主要処理フロー**:
1. **行53-62（VSDialogService）**: NotificationCallbackが設定されている場合はコールバック実行
2. **行65-86（VSDialogService）**: UIモードをモーダルに設定し、ShowMessageBoxを呼び出し、終了後にモーダル解除

#### Step 3: 呼び出し元を理解する

実際にSendNotificationを呼び出しているコマンドハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GoToDefinitionCommandHandler.cs | `src/EditorFeatures/Core/GoToDefinition/GoToDefinitionCommandHandler.cs` | 定義へ移動失敗時の通知使用例 |
| 3-2 | ExtractMethodCommandHandler.cs | `src/EditorFeatures/Core/ExtractMethod/ExtractMethodCommandHandler.cs` | メソッド抽出失敗時の通知使用例 |
| 3-3 | AbstractChangeSignatureCommandHandler.cs | `src/EditorFeatures/Core/ChangeSignature/AbstractChangeSignatureCommandHandler.cs` | シグネチャ変更操作での通知使用例 |

### プログラム呼び出し階層図

```
呼び出し元コマンドハンドラ
    │
    ├─ INotificationService.SendNotification()
    │      │
    │      ├─ VSDialogService (Visual Studio)
    │      │      ├─ NotificationCallback?.Invoke() [テスト時]
    │      │      └─ IVsUIShell.ShowMessageBox() [プロダクション]
    │      │
    │      └─ EditorDialogService (WPF Editor)
    │             ├─ NotificationCallback?.Invoke() [テスト時]
    │             └─ MessageBox.Show() [プロダクション]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

message: string ───────┐
                       │
title: string? ────────┼──▶ INotificationService ──▶ メッセージボックス表示
                       │        │
severity: enum ────────┘        │
                                ▼
                         NotificationCallback
                         (テスト用コールバック)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| INotificationService.cs | `src/Features/Core/Portable/Notification/INotificationService.cs` | インターフェース | 通知サービスの契約定義 |
| INotificationServiceCallback.cs | `src/Features/Core/Portable/Notification/INotificationServiceCallback.cs` | インターフェース | テスト用コールバック契約 |
| VSNotificationServiceFactory.cs | `src/VisualStudio/Core/Def/Notification/VSNotificationServiceFactory.cs` | ソース | Visual Studio環境の実装 |
| EditorNotificationServiceFactory.cs | `src/EditorFeatures/Core/Notification/EditorNotificationServiceFactory.cs` | ソース | エディタ環境の実装 |
| GoToDefinitionCommandHandler.cs | `src/EditorFeatures/Core/GoToDefinition/GoToDefinitionCommandHandler.cs` | ソース | 使用例（GoToDefinition） |
| ExtractMethodCommandHandler.cs | `src/EditorFeatures/Core/ExtractMethod/ExtractMethodCommandHandler.cs` | ソース | 使用例（ExtractMethod） |
| TestNotificationService.vb | `src/EditorFeatures/TestUtilities2/Utilities/TestNotificationService.vb` | テスト | テスト用のモック実装 |
