# 通知設計書 10-NotificationOption2.None

## 概要

本ドキュメントは、Roslynプロジェクトにおける`NotificationOption2.None`コードスタイル通知オプションの設計仕様を記載するものである。このオプションは、コードスタイルルールの診断を抑制（Suppress）するために使用される通知レベル設定である。

### 本通知の処理概要

`NotificationOption2.None`は、`NotificationOption2`構造体の静的プロパティとして定義されており、コードスタイルルールの診断を完全に抑制する設定を表す。内部的には`ReportDiagnostic.Suppress`にマッピングされ、該当するルールに対して診断が生成されないようにする。これはコードスタイルオプションの「通知レベル」を表現する5段階（None、Silent、Suggestion、Warning、Error）のうち、最も抑制的なレベルである。

**業務上の目的・背景**：開発チームによってはプロジェクト固有のコーディング規約があり、Roslynが提供するデフォルトのコードスタイルルールが適用されないようにしたい場合がある。例えば、チームが独自のvarの使用規約を持っている場合、Roslynのvar推奨ルールを無効化することで、不要な診断やコード修正の提案を抑制できる。これにより、開発者はプロジェクトに関連のない診断に惑わされることなく、本当に重要な問題に集中できる。

**通知の送信タイミング**：この設定自体は「送信」されるものではなく、診断アナライザーがコードを分析する際に参照される設定値である。エディタ設定（.editorconfig）やVisual Studioオプションで設定され、アナライザー実行時に評価される。

**通知の受信者**：該当なし。これは診断の生成を制御する設定値であり、通知の受信者は存在しない。

**通知内容の概要**：該当なし。診断が抑制されるため、ユーザーに対して何も表示されない。

**期待されるアクション**：診断が表示されないため、ユーザーの明示的なアクションは不要。ただし、チームのコーディング規約に従ってコードを記述することが期待される。

## 通知種別

診断通知オプション（NotificationOption2）- 抑制レベル

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 診断レベル | Suppress（抑制） |
| ReportDiagnostic値 | ReportDiagnostic.Suppress |
| エディタ表示 | なし |
| ビルドエラー | なし |

### オプション値の構造

```csharp
public static NotificationOption2 None => new(ReportDiagnostic.Suppress, false);
```

## 通知テンプレート

### 5段階の通知レベル

| レベル | 値 | ReportDiagnostic | エディタ表示 | ビルド影響 |
|--------|---|-----------------|-------------|----------|
| **None** | 抑制 | Suppress | なし | なし |
| Silent | 非表示 | Hidden | なし（コード修正のみ提案） | なし |
| Suggestion | 情報 | Info | 灰色の点 | なし |
| Warning | 警告 | Warn | 黄色の波線 | 警告としてレポート |
| Error | エラー | Error | 赤色の波線 | エラーとしてレポート、ビルド失敗 |

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | 診断オプションのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Severity | 重大度（ReportDiagnostic.Suppress） | 静的プロパティ | Yes |
| IsExplicitlySpecified | 明示的に指定されたかどうか（false） | 静的プロパティ | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 設定参照 | アナライザー実行時 | オプション値がNoneの場合 | 診断生成をスキップ |
| 設定参照 | コードスタイル設定読み込み | .editorconfigでnoneが指定された場合 | オプション値をNoneに設定 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Noneが設定されている場合 | 診断自体が生成されないため、「通知」は発生しない |

## 処理フロー

### 診断フロー

```mermaid
flowchart TD
    A[アナライザーがコードを分析] --> B[コードスタイルオプションを取得]
    B --> C{NotificationOption2の値は?}
    C -->|None| D[診断生成をスキップ]
    C -->|Silent以上| E[診断を生成]
    D --> F[終了 - 何も表示されない]
    E --> G[Severityに応じてエディタに表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | データベースアクセスなし（設定はファイルまたはメモリ） |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | データベースへの更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 設定パース失敗 | .editorconfigの値が不正な場合 | デフォルト値にフォールバック |
| 予期しないReportDiagnostic値 | 未知の値が渡された場合 | ExceptionUtilities.UnexpectedValueで例外 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（設定読み込みのため） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| N/A | - | 設定値のため制限なし |

### 配信時間帯

設定値の読み込みは即時に行われるため、時間帯制限なし。

## セキュリティ考慮事項

- 設定値はユーザーまたはプロジェクト管理者が意図的に設定するものであり、信頼される
- 重要なセキュリティルールをNoneに設定すると、脆弱性を見逃す可能性があるため、設定時に注意が必要
- .editorconfigファイルはソースコントロールで管理され、変更履歴が追跡可能

## 備考

- `NotificationOption2`は`record struct`として定義され、値型セマンティクスを持つ
- `DataContract`属性が付与され、シリアライズに対応
- `ForSeverity`静的メソッドにより、`ReportDiagnostic`や`DiagnosticSeverity`から変換可能
- `WithIsExplicitlySpecified`メソッドで、明示的指定フラグを変更した新しいインスタンスを生成可能
- .editorconfigでは`option_name = value:none`の形式で設定

---

## コードリーディングガイド

本通知オプションを理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、NotificationOption2構造体の定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | NotificationOption2構造体の定義、None静的プロパティ（行21）を理解する |

**読解のコツ**: `record struct`として定義されていること、`Severity`と`IsExplicitlySpecified`の2つのプロパティを持つことに注目。

#### Step 2: ReportDiagnosticとの関係を理解する

診断レポートレベルとのマッピングを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | ForSeverityメソッド（行46-55, 57-65）でのマッピングを理解する |

**主要処理フロー**:
1. **行21**: `None => new(ReportDiagnostic.Suppress, false)`
2. **行46-55**: `ForSeverity(ReportDiagnostic)`でReportDiagnosticからNotificationOption2への変換
3. **行53**: `ReportDiagnostic.Suppress => None`

#### Step 3: コードスタイルオプションでの使用を理解する

NotificationOption2がコードスタイルオプションでどのように使用されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CodeStyleOption2`1.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/CodeStyleOption2`1.cs` | コードスタイルオプションでのNotificationプロパティの使用を理解する |
| 3-2 | CodeStyleHelpers.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/CodeStyleHelpers.cs` | .editorconfigからのパース処理を理解する |

#### Step 4: 診断アナライザーでの参照を理解する

アナライザーがNotificationOption2をどのように参照するかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AbstractBuiltInCodeStyleDiagnosticAnalyzer_Core.cs | `src/Analyzers/Core/Analyzers/AbstractBuiltInCodeStyleDiagnosticAnalyzer_Core.cs` | 組み込みコードスタイルアナライザーでのオプション参照を理解する |
| 4-2 | NotificationOptionExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/NotificationOptionExtensions.cs` | 通知オプションの拡張メソッドを理解する |

### プログラム呼び出し階層図

```
.editorconfig / Visual Studio オプション
    │
    ├─ CodeStyleHelpers.TryGetCodeStyleValue()
    │      │
    │      └─ NotificationOption2.ForSeverity() または 直接プロパティ参照
    │
    └─ CodeStyleOption2<T>.Notification プロパティ
           │
           └─ アナライザーが参照
                  │
                  ├─ Severity == ReportDiagnostic.Suppress (None)
                  │      │
                  │      └─ 診断生成をスキップ
                  │
                  └─ Severity != ReportDiagnostic.Suppress
                         │
                         └─ 診断を生成してエディタに表示
```

### データフロー図

```
[入力]                          [処理]                              [出力]

.editorconfig ─────────▶ CodeStyleHelpers.Parse()
                                │
                                ▼
                         NotificationOption2.None
                         (Severity = Suppress)
                                │
                                ▼
                         CodeStyleOption2<T>.Notification
                                │
                                ▼
                         アナライザー実行
                                │
                                ▼
                         ┌─ Suppress? ─┐
                         │             │
                        Yes           No
                         │             │
                         ▼             ▼
                     診断なし      診断生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | ソース | NotificationOption2構造体の定義 |
| NotificationOption2_operators.cs | `src/Workspaces/Core/Portable/CodeStyle/NotificationOption2_operators.cs` | ソース | 演算子オーバーロード |
| CodeStyleOption2`1.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/CodeStyleOption2`1.cs` | ソース | コードスタイルオプションジェネリック型 |
| CodeStyleHelpers.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/CodeStyleHelpers.cs` | ソース | .editorconfigパースヘルパー |
| NotificationOptionExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/NotificationOptionExtensions.cs` | ソース | 通知オプション拡張メソッド |
| DiagnosticSeverityExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/DiagnosticSeverityExtensions.cs` | ソース | 診断重大度拡張メソッド |
| ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ソース | ReportDiagnostic拡張メソッド |
| AbstractBuiltInCodeStyleDiagnosticAnalyzer_Core.cs | `src/Analyzers/Core/Analyzers/AbstractBuiltInCodeStyleDiagnosticAnalyzer_Core.cs` | ソース | 組み込みアナライザー基底クラス |
