# 通知設計書 11-NotificationOption2.Silent

## 概要

本ドキュメントは、Roslynコードスタイル分析機能における `NotificationOption2.Silent` 通知オプションの設計仕様を記述する。Silent通知オプションは、コードスタイル診断を非表示（Hidden）レベルで報告するための設定値である。

### 本通知の処理概要

NotificationOption2.Silentは、コードスタイルルールの診断レベルを「非表示（Hidden）」に設定するための静的プロパティである。この設定を適用すると、診断はエディタ上に視覚的に表示されないが、コード修正（Code Fix）の提案は引き続き利用可能となる。

**業務上の目的・背景**：開発チームがコードスタイルルールを適用したいが、エディタ上での警告表示を控えめにしたい場合に使用する。例えば、新しいコードスタイルを段階的に導入する際や、チーム内での合意形成前に試験的にルールを有効化する場合に適している。開発者の作業を中断させずに、リファクタリング時にのみコード修正を提案できる。

**通知の送信タイミング**：コードスタイルオプションがSilentに設定されている場合、コンパイル時およびエディタでのコード編集時に診断が生成される。ただし、ReportDiagnostic.Hidden として報告されるため、エラーリストやエディタ上の波線として直接表示されることはない。

**通知の受信者**：IDEのコード分析エンジンおよびコードフィックスプロバイダーが受信者となる。開発者は明示的に「クイックアクション」を開くことで、利用可能なコード修正を確認できる。

**通知内容の概要**：診断ID、診断メッセージ、影響を受けるコード位置、および利用可能なコード修正アクション。診断の重大度（Severity）はHiddenとして設定される。

**期待されるアクション**：開発者はリファクタリング作業時に「クイックアクション（Ctrl+.）」を使用して、コードスタイルに準拠したコード修正を適用することが期待される。強制的な対応は求められない。

## 通知種別

アプリ内通知（IDE診断通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | なし |

### 送信先決定ロジック

コードスタイルオプション（EditorConfigまたはIDEオプション）においてNotificationOption2.Silentが設定されているルールに対して、該当するコードパターンが検出された場合に診断が生成される。送信先はIDEの診断サブシステムである。

## 通知テンプレート

### 診断通知の場合

| 項目 | 内容 |
|-----|------|
| 重大度 | Hidden |
| 診断ID | 各コードスタイルルールのID（例: IDE0001, IDE0017等） |
| カテゴリ | Style |

### 本文テンプレート

```
診断は非表示状態です。クイックアクションからコード修正を確認できます。
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Severity | 診断の重大度 | NotificationOption2.Severity | Yes |
| IsExplicitlySpecified | 明示的に設定されたかどうか | NotificationOption2.IsExplicitlySpecified | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コード分析 | ドキュメント変更時 | コードスタイルオプションがSilentに設定 | エディタでのリアルタイム分析 |
| バッチ | ビルド時 | コードスタイルオプションがSilentに設定 | ビルド時の静的分析 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| NotificationOption2.None設定時 | 診断自体が抑制される |
| ルール無効化時 | 該当ルールがEditorConfigで無効化されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コードスタイルオプション取得] --> B{Severity判定}
    B -->|Hidden| C[Silent診断生成]
    B -->|その他| D[対応するレベルで診断生成]
    C --> E[DiagnosticHelper.Create呼び出し]
    E --> F[Diagnostic生成]
    F --> G{表示可能か}
    G -->|No| H[非表示だがCodeFix利用可能]
    G -->|Yes| I[エディタに表示]
    H --> J[終了]
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理）

### 更新テーブル一覧

該当なし（インメモリ処理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効なSeverity値 | 不正なReportDiagnostic値 | ExceptionUtilities.UnexpectedValueをスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（リアルタイム処理）

## セキュリティ考慮事項

特になし。コードスタイル設定は開発者のローカル環境で処理され、外部への通信は発生しない。

## 備考

- NotificationOption2.Silentは`ReportDiagnostic.Hidden`にマッピングされる
- EditorConfig文字列表現は「silent」
- デフォルトの機能設定（TrueWithSilentEnforcement）で使用される標準的な通知レベル

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

NotificationOption2は診断の重大度とそのメタ情報を保持するrecord structである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | Silentプロパティの定義（26行目）、ReportDiagnostic.Hiddenとの関連 |

**読解のコツ**: C# record structの構文に注意。`Severity`と`IsExplicitlySpecified`の2つのプロパティを持つイミュータブルな値型。

#### Step 2: エントリーポイントを理解する

コードスタイルオプションがどのようにNotificationOption2を使用するかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeStyleOption2`1.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/CodeStyleOption2\`1.cs` | Notificationプロパティ（83行目）、TrueWithSilentEnforcementの定義（33行目） |

**主要処理フロー**:
1. **33行目**: `TrueWithSilentEnforcement`静的フィールドでSilent通知オプションのデフォルトインスタンスを定義
2. **83行目**: `Notification`プロパティで通知オプションにアクセス

#### Step 3: 診断生成への適用を理解する

NotificationOption2がどのように診断生成に使用されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DiagnosticHelper.cs | `src/Analyzers/Core/Analyzers/Helpers/DiagnosticHelper.cs` | Create メソッド（39-53行目）、CreateWithMessage メソッド（254-318行目） |

**主要処理フロー**:
- **268行目**: `notificationOption.Severity`から実効的な重大度を取得
- **269-284行目**: Diagnostic.Createの呼び出しでSeverityを適用

#### Step 4: 拡張メソッドを理解する

通知オプションの変換と拡張機能を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | NotificationOptionExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/NotificationOptionExtensions.cs` | ToEditorConfigStringメソッド（11-12行目） |
| 4-2 | ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ToEditorConfigStringメソッド（12-23行目）、ToNotificationOptionメソッド（25-39行目） |

**主要処理フロー**:
- **17行目（ReportDiagnosticExtensions.cs）**: `ReportDiagnostic.Hidden`を「silent」文字列に変換
- **33行目（ReportDiagnosticExtensions.cs）**: `ReportDiagnostic.Hidden`から`NotificationOption2.Silent`への変換

### プログラム呼び出し階層図

```
CodeStyleOption2<T>.Notification
    │
    └─ NotificationOption2.Silent
           │
           ├─ ReportDiagnostic.Hidden (Severity)
           │
           └─ DiagnosticHelper.Create
                  │
                  └─ Diagnostic.Create（診断インスタンス生成）
```

### データフロー図

```
[入力]                    [処理]                          [出力]

EditorConfig設定  ───▶  CodeStyleOption2解析  ───▶  NotificationOption2.Silent
                              │
                              ▼
                        DiagnosticHelper
                              │
                              ▼
                        Diagnostic生成（Hidden重大度）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | ソース | 通知オプションの定義 |
| CodeStyleOption2`1.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/CodeStyleOption2\`1.cs` | ソース | コードスタイルオプションのラッパー |
| DiagnosticHelper.cs | `src/Analyzers/Core/Analyzers/Helpers/DiagnosticHelper.cs` | ソース | 診断生成ヘルパー |
| NotificationOptionExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/NotificationOptionExtensions.cs` | ソース | 拡張メソッド |
| ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ソース | ReportDiagnostic拡張 |
