# 通知設計書 12-NotificationOption2.Suggestion

## 概要

本ドキュメントは、Roslynコードスタイル分析機能における `NotificationOption2.Suggestion` 通知オプションの設計仕様を記述する。Suggestion通知オプションは、コードスタイル診断を情報レベル（Info）で報告するための設定値である。

### 本通知の処理概要

NotificationOption2.Suggestionは、コードスタイルルールの診断レベルを「情報（Info）」に設定するための静的プロパティである。この設定を適用すると、診断は提案（Suggestion）として表示され、開発者に改善の余地があることを控えめに通知する。

**業務上の目的・背景**：コード品質向上のための推奨事項を開発者に伝えるが、強制ではなく任意の改善として位置づける場合に使用する。例えば、可読性向上のためのリファクタリング提案や、新しいC#言語機能の使用推奨などに適している。開発者の判断に委ねつつ、ベストプラクティスを促進できる。

**通知の送信タイミング**：コードスタイルオプションがSuggestionに設定されている場合、コンパイル時およびエディタでのコード編集時に診断が生成される。ReportDiagnostic.Info として報告され、エディタ上で緑色の波線（または点線）として視覚的に表示される。

**通知の受信者**：開発者およびIDEのコード分析エンジン。エラーリストには「メッセージ」として表示され、クイックアクションからコード修正を適用できる。

**通知内容の概要**：診断ID、診断メッセージ、影響を受けるコード位置、および利用可能なコード修正アクション。診断の重大度（Severity）はInfoとして設定され、提案として扱われる。

**期待されるアクション**：開発者はエディタ上の提案表示を確認し、コードスタイルガイドラインに従ってコードを修正することが推奨される。ただし、対応は任意であり、ビルドエラーにはならない。

## 通知種別

アプリ内通知（IDE診断通知 - 情報レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 低 |
| リトライ | なし |

### 送信先決定ロジック

コードスタイルオプション（EditorConfigまたはIDEオプション）においてNotificationOption2.Suggestionが設定されているルールに対して、該当するコードパターンが検出された場合に診断が生成される。送信先はIDEの診断サブシステムである。

## 通知テンプレート

### 診断通知の場合

| 項目 | 内容 |
|-----|------|
| 重大度 | Info（提案） |
| 診断ID | 各コードスタイルルールのID（例: IDE0001, IDE0017等） |
| カテゴリ | Style |
| 視覚表示 | 緑色の波線または点線 |

### 本文テンプレート

```
{診断メッセージ}
（例: 'var' の使用を検討してください）
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Severity | 診断の重大度 | NotificationOption2.Severity | Yes |
| IsExplicitlySpecified | 明示的に設定されたかどうか | NotificationOption2.IsExplicitlySpecified | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コード分析 | ドキュメント変更時 | コードスタイルオプションがSuggestionに設定 | エディタでのリアルタイム分析 |
| バッチ | ビルド時 | コードスタイルオプションがSuggestionに設定 | ビルド時の静的分析（警告として扱わない） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| NotificationOption2.None設定時 | 診断自体が抑制される |
| NotificationOption2.Silent設定時 | 非表示レベルに変更される |
| ルール無効化時 | 該当ルールがEditorConfigで無効化されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コードスタイルオプション取得] --> B{Severity判定}
    B -->|Info| C[Suggestion診断生成]
    B -->|その他| D[対応するレベルで診断生成]
    C --> E[DiagnosticHelper.Create呼び出し]
    E --> F[Diagnostic生成]
    F --> G[エディタに緑色波線表示]
    G --> H[エラーリストにメッセージとして表示]
    H --> I[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理）

### 更新テーブル一覧

該当なし（インメモリ処理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効なSeverity値 | 不正なReportDiagnostic値 | ExceptionUtilities.UnexpectedValueをスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（リアルタイム処理）

## セキュリティ考慮事項

特になし。コードスタイル設定は開発者のローカル環境で処理され、外部への通信は発生しない。

## 備考

- NotificationOption2.Suggestionは`ReportDiagnostic.Info`にマッピングされる
- EditorConfig文字列表現は「suggestion」
- `TrueWithSuggestionEnforcement`という事前定義されたインスタンスが利用可能
- 提案レベルはビルドエラーにならず、CI/CDパイプラインを妨げない

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

NotificationOption2.Suggestionの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | Suggestionプロパティの定義（29-31行目）、ReportDiagnostic.Infoとの関連 |

**読解のコツ**: XMLドキュメントコメントで「suggestion or an info option」と説明されていることに注目。

#### Step 2: エントリーポイントを理解する

事前定義されたSuggestionインスタンスの使用方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeStyleOption2`1.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/CodeStyleOption2\`1.cs` | TrueWithSuggestionEnforcementの定義（35行目）、FalseWithSuggestionEnforcementの定義（36行目） |

**主要処理フロー**:
1. **35行目**: `TrueWithSuggestionEnforcement`静的フィールドでSuggestion通知オプションのインスタンスを定義
2. **46行目**: `GetCodeStyle`メソッドでSuggestionインスタンスを返却

#### Step 3: 診断生成への適用を理解する

NotificationOption2がどのように診断生成に使用されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DiagnosticHelper.cs | `src/Analyzers/Core/Analyzers/Helpers/DiagnosticHelper.cs` | CreateWithMessageメソッド（254-318行目）での重大度適用 |

**主要処理フロー**:
- **268行目**: `notificationOption.Severity`から実効的な重大度を取得
- **273行目**: `effectiveSeverity.ToDiagnosticSeverity()`でDiagnosticSeverity.Infoに変換

#### Step 4: EditorConfig文字列変換を理解する

通知オプションのEditorConfig表現を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ToEditorConfigStringメソッド（18行目）でInfo→「suggestion」変換 |

**主要処理フロー**:
- **18行目**: `ReportDiagnostic.Info`を「suggestion」文字列に変換

### プログラム呼び出し階層図

```
CodeStyleOption2<T>.Notification
    │
    └─ NotificationOption2.Suggestion
           │
           ├─ ReportDiagnostic.Info (Severity)
           │
           └─ DiagnosticHelper.Create
                  │
                  └─ Diagnostic.Create（診断インスタンス生成）
                         │
                         └─ DiagnosticSeverity.Info
```

### データフロー図

```
[入力]                    [処理]                          [出力]

EditorConfig設定  ───▶  CodeStyleOption2解析  ───▶  NotificationOption2.Suggestion
     │                        │
     │                        ▼
     │                  DiagnosticHelper
     │                        │
     ▼                        ▼
"suggestion"          Diagnostic生成（Info重大度）
                              │
                              ▼
                      エディタ表示（緑波線）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | ソース | 通知オプションの定義 |
| CodeStyleOption2`1.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/CodeStyleOption2\`1.cs` | ソース | コードスタイルオプションのラッパー |
| DiagnosticHelper.cs | `src/Analyzers/Core/Analyzers/Helpers/DiagnosticHelper.cs` | ソース | 診断生成ヘルパー |
| ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ソース | ReportDiagnostic拡張 |
