# 通知設計書 13-NotificationOption2.Warning

## 概要

本ドキュメントは、Roslynコードスタイル分析機能における `NotificationOption2.Warning` 通知オプションの設計仕様を記述する。Warning通知オプションは、コードスタイル診断を警告レベル（Warn）で報告するための設定値である。

### 本通知の処理概要

NotificationOption2.Warningは、コードスタイルルールの診断レベルを「警告（Warn）」に設定するための静的プロパティである。この設定を適用すると、診断は警告として表示され、開発者に対して注意が必要な問題であることを明確に通知する。

**業務上の目的・背景**：コード品質基準の遵守を促すために使用される。警告レベルは、問題はあるがビルドを妨げない程度の重要度を示す。チームのコーディング規約を浸透させ、コードレビュー前に自動的に問題を検出することで、レビュー効率を向上させる。CI/CDパイプラインで「警告をエラーとして扱う」設定と組み合わせることで、コード品質ゲートとしても機能する。

**通知の送信タイミング**：コードスタイルオプションがWarningに設定されている場合、コンパイル時およびエディタでのコード編集時に診断が生成される。ReportDiagnostic.Warn として報告され、エディタ上で黄色（または緑色）の波線として視覚的に表示される。

**通知の受信者**：開発者およびIDEのコード分析エンジン。エラーリストには「警告」として表示され、警告数としてカウントされる。クイックアクションからコード修正を適用できる。

**通知内容の概要**：診断ID、診断メッセージ、影響を受けるコード位置、および利用可能なコード修正アクション。診断の重大度（Severity）はWarningとして設定され、warningLevelは1に設定される。

**期待されるアクション**：開発者はエディタ上の警告表示を確認し、コードスタイルガイドラインに従ってコードを修正することが期待される。警告を無視してビルドは可能だが、警告数の増加はコード品質の低下を示す指標となる。

## 通知種別

アプリ内通知（IDE診断通知 - 警告レベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

コードスタイルオプション（EditorConfigまたはIDEオプション）においてNotificationOption2.Warningが設定されているルールに対して、該当するコードパターンが検出された場合に診断が生成される。送信先はIDEの診断サブシステムである。

## 通知テンプレート

### 診断通知の場合

| 項目 | 内容 |
|-----|------|
| 重大度 | Warning（警告） |
| 診断ID | 各コードスタイルルールのID（例: IDE0001, IDE0017等） |
| カテゴリ | Style |
| 視覚表示 | 黄色の波線 |
| 警告レベル | 1 |

### 本文テンプレート

```
{診断メッセージ}
（例: 名前を簡略化できます）
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Severity | 診断の重大度 | NotificationOption2.Severity | Yes |
| IsExplicitlySpecified | 明示的に設定されたかどうか | NotificationOption2.IsExplicitlySpecified | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コード分析 | ドキュメント変更時 | コードスタイルオプションがWarningに設定 | エディタでのリアルタイム分析 |
| バッチ | ビルド時 | コードスタイルオプションがWarningに設定 | ビルド時の静的分析（警告として報告） |
| CI/CD | プルリクエスト時 | コードスタイルオプションがWarningに設定 | 自動品質チェック |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| NotificationOption2.None設定時 | 診断自体が抑制される |
| NotificationOption2.Silent設定時 | 非表示レベルに変更される |
| NotificationOption2.Suggestion設定時 | 情報レベルに変更される |
| ルール無効化時 | 該当ルールがEditorConfigで無効化されている場合 |
| #pragma warning disable | コード内で警告が抑制されている場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コードスタイルオプション取得] --> B{Severity判定}
    B -->|Warn| C[Warning診断生成]
    B -->|その他| D[対応するレベルで診断生成]
    C --> E[DiagnosticHelper.Create呼び出し]
    E --> F[Diagnostic生成]
    F --> G[warningLevel = 1 設定]
    G --> H[エディタに黄色波線表示]
    H --> I[エラーリストに警告として表示]
    I --> J[警告カウント増加]
    J --> K[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理）

### 更新テーブル一覧

該当なし（インメモリ処理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効なSeverity値 | 不正なReportDiagnostic値 | ExceptionUtilities.UnexpectedValueをスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（リアルタイム処理）

## セキュリティ考慮事項

特になし。コードスタイル設定は開発者のローカル環境で処理され、外部への通信は発生しない。

## 備考

- NotificationOption2.Warningは`ReportDiagnostic.Warn`にマッピングされる
- EditorConfig文字列表現は「warning」
- ビルドは成功するが、警告としてコンパイラ出力に表示される
- 「警告をエラーとして扱う」（TreatWarningsAsErrors）設定でビルド失敗にできる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

NotificationOption2.Warningの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | Warningプロパティの定義（33-36行目）、ReportDiagnostic.Warnとの関連 |

**読解のコツ**: XMLドキュメントコメントで「warning option」と説明されていることに注目。

#### Step 2: 診断生成への適用を理解する

NotificationOption2がどのように診断生成に使用されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DiagnosticHelper.cs | `src/Analyzers/Core/Analyzers/Helpers/DiagnosticHelper.cs` | CreateWithMessageメソッド（254-318行目）、warningLevel設定（276行目） |

**主要処理フロー**:
1. **268行目**: `notificationOption.Severity`から実効的な重大度を取得
2. **276行目**: `warningLevel: effectiveSeverity == ReportDiagnostic.Error ? 0 : 1`でwarningLevelを1に設定

#### Step 3: EditorConfig文字列変換を理解する

通知オプションのEditorConfig表現を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ToEditorConfigStringメソッド（19行目）でWarn→「warning」変換 |

**主要処理フロー**:
- **19行目**: `ReportDiagnostic.Warn`を「warning」文字列に変換

#### Step 4: 変換ロジックを理解する

ReportDiagnosticとNotificationOption2の相互変換を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | ForSeverityメソッド（46-55行目、57-65行目） |
| 4-2 | ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ToNotificationOptionメソッド（25-39行目） |

**主要処理フロー**:
- **49行目（NotificationOption2.cs）**: `ReportDiagnostic.Warn => Warning`の変換
- **31行目（ReportDiagnosticExtensions.cs）**: `ReportDiagnostic.Warn => NotificationOption2.Warning`

### プログラム呼び出し階層図

```
CodeStyleOption2<T>.Notification
    │
    └─ NotificationOption2.Warning
           │
           ├─ ReportDiagnostic.Warn (Severity)
           │
           └─ DiagnosticHelper.Create
                  │
                  └─ Diagnostic.Create（診断インスタンス生成）
                         │
                         ├─ DiagnosticSeverity.Warning
                         │
                         └─ warningLevel = 1
```

### データフロー図

```
[入力]                    [処理]                          [出力]

EditorConfig設定  ───▶  CodeStyleOption2解析  ───▶  NotificationOption2.Warning
     │                        │
     │                        ▼
     │                  DiagnosticHelper
     │                        │
     ▼                        ▼
"warning"             Diagnostic生成（Warning重大度）
                              │
                              ├─▶ エディタ表示（黄色波線）
                              │
                              └─▶ 警告カウント（+1）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | ソース | 通知オプションの定義 |
| DiagnosticHelper.cs | `src/Analyzers/Core/Analyzers/Helpers/DiagnosticHelper.cs` | ソース | 診断生成ヘルパー |
| ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ソース | ReportDiagnostic拡張 |
