# 通知設計書 14-NotificationOption2.Error

## 概要

本ドキュメントは、Roslynコードスタイル分析機能における `NotificationOption2.Error` 通知オプションの設計仕様を記述する。Error通知オプションは、コードスタイル診断をエラーレベル（Error）で報告するための設定値である。

### 本通知の処理概要

NotificationOption2.Errorは、コードスタイルルールの診断レベルを「エラー（Error）」に設定するための静的プロパティである。この設定を適用すると、診断はエラーとして扱われ、ビルドが失敗する。最も厳格なコードスタイル強制レベルである。

**業務上の目的・背景**：コード品質基準を強制的に遵守させるために使用される。エラーレベルは、修正必須の問題を示し、ビルドを妨げる。チームのコーディング規約違反を絶対に許容しない場合や、セキュリティ関連のコードパターン違反を検出する場合に使用する。プルリクエストのマージ前に確実にコード品質を保証できる。

**通知の送信タイミング**：コードスタイルオプションがErrorに設定されている場合、コンパイル時およびエディタでのコード編集時に診断が生成される。ReportDiagnostic.Error として報告され、エディタ上で赤色の波線として視覚的に表示される。ビルドはエラーで失敗する。

**通知の受信者**：開発者およびIDEのコード分析エンジン。エラーリストには「エラー」として表示され、エラー数としてカウントされる。クイックアクションからコード修正を適用できる。

**通知内容の概要**：診断ID、診断メッセージ、影響を受けるコード位置、および利用可能なコード修正アクション。診断の重大度（Severity）はErrorとして設定され、warningLevelは0に設定される。

**期待されるアクション**：開発者はエディタ上のエラー表示を確認し、コードスタイルガイドラインに従ってコードを修正することが必須となる。エラーを解決しない限りビルドは成功しない。

## 通知種別

アプリ内通知（IDE診断通知 - エラーレベル）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高 |
| リトライ | なし |

### 送信先決定ロジック

コードスタイルオプション（EditorConfigまたはIDEオプション）においてNotificationOption2.Errorが設定されているルールに対して、該当するコードパターンが検出された場合に診断が生成される。送信先はIDEの診断サブシステムである。

## 通知テンプレート

### 診断通知の場合

| 項目 | 内容 |
|-----|------|
| 重大度 | Error（エラー） |
| 診断ID | 各コードスタイルルールのID（例: IDE0001, IDE0017等） |
| カテゴリ | Style |
| 視覚表示 | 赤色の波線 |
| 警告レベル | 0 |

### 本文テンプレート

```
{診断メッセージ}
（例: 名前を簡略化できます - エラー）
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| Severity | 診断の重大度 | NotificationOption2.Severity | Yes |
| IsExplicitlySpecified | 明示的に設定されたかどうか | NotificationOption2.IsExplicitlySpecified | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| コード分析 | ドキュメント変更時 | コードスタイルオプションがErrorに設定 | エディタでのリアルタイム分析 |
| バッチ | ビルド時 | コードスタイルオプションがErrorに設定 | ビルド時の静的分析（エラーとして報告、ビルド失敗） |
| CI/CD | プルリクエスト時 | コードスタイルオプションがErrorに設定 | 自動品質チェック（ビルド失敗でマージ不可） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| NotificationOption2.None設定時 | 診断自体が抑制される |
| NotificationOption2.Silent設定時 | 非表示レベルに変更される |
| NotificationOption2.Suggestion設定時 | 情報レベルに変更される |
| NotificationOption2.Warning設定時 | 警告レベルに変更される |
| ルール無効化時 | 該当ルールがEditorConfigで無効化されている場合 |
| #pragma warning disable | コード内でエラーが抑制されている場合（非推奨） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[コードスタイルオプション取得] --> B{Severity判定}
    B -->|Error| C[Error診断生成]
    B -->|その他| D[対応するレベルで診断生成]
    C --> E[DiagnosticHelper.Create呼び出し]
    E --> F[Diagnostic生成]
    F --> G[warningLevel = 0 設定]
    G --> H[エディタに赤色波線表示]
    H --> I[エラーリストにエラーとして表示]
    I --> J[エラーカウント増加]
    J --> K{ビルド実行?}
    K -->|Yes| L[ビルド失敗]
    K -->|No| M[編集続行可能]
    L --> N[終了]
    M --> N
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理）

### 更新テーブル一覧

該当なし（インメモリ処理）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 無効なSeverity値 | 不正なReportDiagnostic値 | ExceptionUtilities.UnexpectedValueをスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（リアルタイム処理）

## セキュリティ考慮事項

- Error通知は誤って抑制されないよう注意が必要
- セキュリティ関連ルールのError設定は変更監査を推奨
- 外部通信は発生しない

## 備考

- NotificationOption2.Errorは`ReportDiagnostic.Error`にマッピングされる
- EditorConfig文字列表現は「error」
- ビルドは失敗し、成果物は生成されない
- warningLevelが0に設定されることでエラーとして扱われる
- コードスタイルルールをエラーに設定するのは最も厳格な運用

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

NotificationOption2.Errorの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | Errorプロパティの定義（38-41行目）、ReportDiagnostic.Errorとの関連 |

**読解のコツ**: XMLドキュメントコメントで「error option」と説明されていることに注目。

#### Step 2: 診断生成への適用を理解する

NotificationOption2がどのように診断生成に使用されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DiagnosticHelper.cs | `src/Analyzers/Core/Analyzers/Helpers/DiagnosticHelper.cs` | CreateWithMessageメソッド（254-318行目）、warningLevel設定（276行目） |

**主要処理フロー**:
1. **268行目**: `notificationOption.Severity`から実効的な重大度を取得
2. **276行目**: `warningLevel: effectiveSeverity == ReportDiagnostic.Error ? 0 : 1`でwarningLevelを0に設定（エラーの場合）

#### Step 3: EditorConfig文字列変換を理解する

通知オプションのEditorConfig表現を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ToEditorConfigStringメソッド（20行目）でError→「error」変換 |

**主要処理フロー**:
- **20行目**: `ReportDiagnostic.Error`を「error」文字列に変換

#### Step 4: 変換ロジックを理解する

ReportDiagnosticとNotificationOption2の相互変換を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | ForSeverityメソッド（46-55行目、57-65行目） |
| 4-2 | ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ToNotificationOptionメソッド（25-39行目） |

**主要処理フロー**:
- **48行目（NotificationOption2.cs）**: `ReportDiagnostic.Error => Error`の変換
- **60行目（NotificationOption2.cs）**: `DiagnosticSeverity.Error => Error`の変換
- **30行目（ReportDiagnosticExtensions.cs）**: `ReportDiagnostic.Error => NotificationOption2.Error`

### プログラム呼び出し階層図

```
CodeStyleOption2<T>.Notification
    │
    └─ NotificationOption2.Error
           │
           ├─ ReportDiagnostic.Error (Severity)
           │
           └─ DiagnosticHelper.Create
                  │
                  └─ Diagnostic.Create（診断インスタンス生成）
                         │
                         ├─ DiagnosticSeverity.Error
                         │
                         └─ warningLevel = 0（エラー）
```

### データフロー図

```
[入力]                    [処理]                          [出力]

EditorConfig設定  ───▶  CodeStyleOption2解析  ───▶  NotificationOption2.Error
     │                        │
     │                        ▼
     │                  DiagnosticHelper
     │                        │
     ▼                        ▼
"error"               Diagnostic生成（Error重大度）
                              │
                              ├─▶ エディタ表示（赤色波線）
                              │
                              ├─▶ エラーカウント（+1）
                              │
                              └─▶ ビルド失敗
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NotificationOption2.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` | ソース | 通知オプションの定義 |
| DiagnosticHelper.cs | `src/Analyzers/Core/Analyzers/Helpers/DiagnosticHelper.cs` | ソース | 診断生成ヘルパー |
| ReportDiagnosticExtensions.cs | `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` | ソース | ReportDiagnostic拡張 |
