# 通知設計書 15-INotificationHandler

## 概要

本ドキュメントは、Roslyn Language Server Protocol（LSP）フレームワークにおける `INotificationHandler<TRequestContext>` インターフェースの設計仕様を記述する。このインターフェースは、パラメータなしのLSP通知を処理するためのハンドラの契約を定義する。

### 本通知の処理概要

INotificationHandler<TRequestContext>は、Language Server Protocol（LSP）においてパラメータを持たない通知メッセージを処理するためのジェネリックインターフェースである。クライアントからサーバーへの一方向通知（レスポンスを返さないメッセージ）を受信・処理するために使用される。

**業務上の目的・背景**：LSPは言語サーバーとエディタ間の通信プロトコルであり、通知は応答を必要としない一方向メッセージである。パラメータなし通知は、初期化完了通知（initialized）やシャットダウン通知など、追加情報を必要としないイベントの伝達に使用される。このインターフェースを実装することで、言語サーバーがこれらの通知を統一的に処理できる。

**通知の送信タイミング**：クライアント（IDE等）がLSPプロトコルに従って通知メッセージを送信した時点で、対応するハンドラのHandleNotificationAsyncメソッドが呼び出される。通知はJSON-RPC形式でシリアライズされてネットワーク経由で送信される。

**通知の受信者**：LSPサーバー内の登録されたINotificationHandler実装クラス。ハンドラはLanguageServerEndpoint属性でメソッド名と対応付けられる。

**通知内容の概要**：パラメータなしの通知のため、通知内容はメソッド名のみである。RequestContextを通じて現在のサーバー状態やワークスペース情報にアクセスできる。

**期待されるアクション**：ハンドラ実装クラスは、受信した通知に対応する処理（状態更新、ログ記録、イベント発火など）を非同期で実行する。処理完了後もクライアントへのレスポンスは送信されない。

## 通知種別

LSP通知（Language Server Protocol）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（一方向） |
| 優先度 | 通知内容による |
| リトライ | なし（通知のため） |

### 送信先決定ロジック

LSPフレームワークがLanguageServerEndpoint属性に基づいてハンドラを自動的にルーティングする。メソッド名と言語タイプに基づいて適切なハンドラが選択される。

## 通知テンプレート

### LSP通知の場合

| 項目 | 内容 |
|-----|------|
| プロトコル | JSON-RPC 2.0 |
| メッセージタイプ | notification |
| パラメータ | なし |

### 本文テンプレート

```json
{
  "jsonrpc": "2.0",
  "method": "{メソッド名}",
  "params": null
}
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| method | LSPメソッド名 | LanguageServerEndpoint属性 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| クライアント操作 | LSPイベント発生 | LSPサーバーが起動している | クライアントからの通知送信 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| サーバー未起動 | LSPサーバーが起動していない場合 |
| ハンドラ未登録 | 対応するハンドラが登録されていない場合 |

## 処理フロー

### 受信フロー

```mermaid
flowchart TD
    A[クライアントから通知受信] --> B[JSON-RPCデシリアライズ]
    B --> C[メソッド名からハンドラ検索]
    C --> D{ハンドラ存在?}
    D -->|Yes| E[RequestContext生成]
    D -->|No| F[通知を無視]
    E --> G[HandleNotificationAsync呼び出し]
    G --> H[通知処理実行]
    H --> I[処理完了]
    I --> J[終了（レスポンスなし）]
    F --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理）

### 更新テーブル一覧

該当なし（ハンドラ実装による）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ハンドラ未登録 | 対応するハンドラがない | 通知を無視（ログ記録） |
| 処理例外 | ハンドラ内で例外発生 | 例外をログ記録、クライアントには通知しない |
| キャンセル | CancellationTokenがキャンセル | 処理を中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（通知のためリトライなし） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（クライアント依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（リアルタイム処理）

## セキュリティ考慮事項

- LSP通信はローカルプロセス間通信が一般的
- ネットワーク経由の場合はTLSの使用を推奨
- 認証はLSPプロトコルレベルでは定義されていない

## 備考

- INotificationHandler<TRequestContext>はIMethodHandlerを継承
- HandleNotificationAsyncメソッドは非同期Taskを返す
- MutatesSolutionStateプロパティでソリューション状態の変更有無を示す
- パラメータ付き通知にはINotificationHandler<TRequest, TRequestContext>を使用

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

INotificationHandlerインターフェースの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | INotificationHandler.cs | `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/INotificationHandler.cs` | インターフェース定義（17-20行目）、IMethodHandler継承 |

**読解のコツ**: ジェネリック型パラメータTRequestContextがリクエストコンテキストの型を表すことに注目。HandleNotificationAsyncがTaskを返す非同期メソッドであることを確認。

#### Step 2: 実装例を理解する

実際のハンドラ実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InitializedHandler.cs | `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/Handlers/InitializedHandler.cs` | 具体的な実装例、LanguageServerEndpoint属性の使用（14行目） |

**主要処理フロー**:
1. **14行目**: `[LanguageServerEndpoint("initialized", ...)]`でメソッド名を定義
2. **19行目**: `MutatesSolutionState => true`でソリューション状態変更を宣言
3. **21-28行目**: `HandleNotificationAsync`の実装

#### Step 3: ハンドラディスパッチを理解する

通知がどのようにハンドラに振り分けられるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MethodHandlerDetails.cs | `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/MethodHandlerDetails.cs` | ハンドラ情報の抽出（85-88行目）、INotificationHandler<>の検出 |

**主要処理フロー**:
- **85-88行目**: `typeof(INotificationHandler<>)`の検出とメタデータ抽出

#### Step 4: キュー処理を理解する

通知の非同期処理フローを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | QueueItem.cs | `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/QueueItem.cs` | StartRequestAsyncでの通知処理（209-214行目） |

**主要処理フロー**:
- **209-211行目**: `INotificationHandler<TRequestContext>`の判定と呼び出し
- **213-214行目**: NoValue.Instanceの返却（通知は値を返さない）

### プログラム呼び出し階層図

```
LSPクライアント（IDE）
    │
    ▼
JSON-RPC受信
    │
    ▼
MethodHandlerDetails.From
    │
    └─ INotificationHandler<TRequestContext>検出
           │
           ▼
QueueItem.StartRequestAsync
    │
    └─ HandleNotificationAsync呼び出し
           │
           ▼
具体的なハンドラ実装（例: InitializedHandler）
```

### データフロー図

```
[入力]                    [処理]                          [出力]

JSON-RPC通知  ───▶  AbstractLanguageServer  ───▶  RequestContext生成
     │                      │
     │                      ▼
     │               QueueItem処理
     │                      │
     ▼                      ▼
method名          HandleNotificationAsync
                          │
                          ▼
                  （レスポンスなし）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| INotificationHandler.cs | `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/INotificationHandler.cs` | ソース | インターフェース定義 |
| InitializedHandler.cs | `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/Handlers/InitializedHandler.cs` | ソース | 実装例 |
| MethodHandlerDetails.cs | `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/MethodHandlerDetails.cs` | ソース | ハンドラメタデータ抽出 |
| QueueItem.cs | `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/QueueItem.cs` | ソース | 通知処理キュー |
| ILspServiceNotificationHandler.cs | `src/LanguageServer/Protocol/Handler/ILspServiceNotificationHandler.cs` | ソース | Roslyn LSP拡張 |
