# 通知設計書 17-OmniSharpSendNotification

## 概要

本ドキュメントは、Roslyn外部アクセス機能における `OmniSharpSendNotification` 通知サービスの設計仕様を記述する。このメソッドは、OmniSharp統合環境向けにメッセージボックス形式の通知を表示するために使用される。

### 本通知の処理概要

OmniSharpSendNotificationは、IOmniSharpNotificationServiceインターフェースで定義されたメソッドであり、OmniSharpプラットフォーム（Visual Studio Code、Vim、Emacs等のエディタ向け）でユーザーに対してメッセージ通知を表示する。OKボタン付きのメッセージボックスとして表示され、Information、Warning、Errorの3種類の重大度をサポートする。

**業務上の目的・背景**：OmniSharpは.NETプロジェクトの言語サービスを提供するサーバーであり、Visual Studio Code等の軽量エディタで使用される。Roslynの機能を利用しながらも、Visual Studio以外のエディタ環境でも通知機能を利用できるようにするため、この外部アクセス層が設計された。開発者は編集作業中に重要なメッセージや警告を受け取ることができる。

**通知の送信タイミング**：Roslynの言語サービスが重要なメッセージをユーザーに伝える必要がある場合に呼び出される。例えば、プロジェクト読み込みエラー、設定の問題、リファクタリング前の警告などのシナリオで使用される。

**通知の受信者**：OmniSharpクライアント（VS Code拡張機能等）を通じて、最終的にはエディタを使用している開発者がメッセージボックスを受け取る。

**通知内容の概要**：通知メッセージ本文、オプションのタイトル、および重大度（Information/Warning/Error）。重大度に応じて視覚的な表示が異なる。

**期待されるアクション**：開発者はメッセージを確認し、OKボタンをクリックしてメッセージボックスを閉じる。メッセージの内容に応じて、必要な対応（設定の修正、ファイルの更新等）を行う。

## 通知種別

アプリ内通知（メッセージボックス形式）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 重大度に依存（Information/Warning/Error） |
| リトライ | なし |

### 送信先決定ロジック

IOmniSharpNotificationServiceの実装クラスが登録されている場合に、そのインスタンスのSendNotificationメソッドが呼び出される。OmniSharpホストが実装を提供する。

## 通知テンプレート

### メッセージボックス通知の場合

| 項目 | 内容 |
|-----|------|
| 表示形式 | メッセージボックス（OKボタン付き） |
| タイトル | オプション（省略可能） |
| 重大度 | Information / Warning / Error |

### 本文テンプレート

```
{タイトル（省略可能）}

{メッセージ本文}

[OK]
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | 通知メッセージ本文 | 呼び出し元 | Yes |
| title | メッセージボックスのタイトル | 呼び出し元 | No |
| severity | メッセージの重大度 | OmniSharpNotificationSeverity | No（デフォルト: Warning） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プロジェクト操作 | プロジェクト読み込みエラー | エラー発生時 | プロジェクト構成の問題を通知 |
| リファクタリング | リファクタリング前警告 | 警告が必要な場合 | 破壊的変更の警告 |
| 設定変更 | 設定の問題検出 | 問題検出時 | 設定ファイルの問題を通知 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| サービス未登録 | IOmniSharpNotificationServiceの実装が登録されていない場合 |
| ヘッドレスモード | ユーザーインターフェースが利用できない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[通知要求発生] --> B{IOmniSharpNotificationService存在?}
    B -->|Yes| C[SendNotification呼び出し]
    B -->|No| D[通知スキップ]
    C --> E[OmniSharpホストに転送]
    E --> F[エディタにメッセージボックス表示]
    F --> G[ユーザーがOKクリック]
    G --> H[終了]
    D --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理）

### 更新テーブル一覧

該当なし（UI表示のみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| サービス未登録 | IOmniSharpNotificationServiceがない | 通知をスキップ |
| 表示失敗 | エディタ側での表示エラー | ログ記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（過度な使用は避けるべき） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じてリアルタイム表示）

## セキュリティ考慮事項

- メッセージ内容に機密情報を含めないこと
- ユーザーフィッシングに利用されないよう、信頼できるソースからのメッセージのみ表示
- 外部通信は発生しない

## 備考

- IOmniSharpNotificationServiceはMicrosoft.CodeAnalysis.ExternalAccess.OmniSharp.Notification名前空間で定義
- OmniSharpNotificationSeverityはNotificationSeverity列挙型にマッピング
- デフォルトの重大度はWarning
- titleパラメータはnull許容で、一部の実装では無視される場合がある

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

IOmniSharpNotificationServiceインターフェースと関連する型を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOmniSharpNotificationService.cs | `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` | SendNotificationメソッドの定義（15-18行目） |
| 1-2 | OmniSharpNotificationSeverity.cs | `src/Features/ExternalAccess/OmniSharp/Notification/OmniSharpNotificationSeverity.cs` | 重大度列挙型の定義（9-14行目） |

**読解のコツ**: SendNotificationメソッドのパラメータに注目。messageが必須、title/severityがオプション。severityのデフォルト値はWarning。

#### Step 2: メソッドシグネチャを理解する

SendNotificationメソッドの詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOmniSharpNotificationService.cs | `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` | XMLドキュメントコメント（9-14行目）でメソッドの目的を確認 |

**主要処理フロー**:
1. **12行目**: `message`パラメータ - メッセージボックス内に表示されるメッセージ
2. **13行目**: `title`パラメータ - タイトルバー（一部実装で無視される可能性あり）
3. **14行目**: `severity`パラメータ - メッセージの重大度

#### Step 3: 重大度マッピングを理解する

OmniSharp重大度と内部NotificationSeverityの関係を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OmniSharpNotificationSeverity.cs | `src/Features/ExternalAccess/OmniSharp/Notification/OmniSharpNotificationSeverity.cs` | NotificationSeverityへのマッピング（11-13行目） |

**主要処理フロー**:
- **11行目**: `Information = NotificationSeverity.Information`
- **12行目**: `Warning = NotificationSeverity.Warning`
- **13行目**: `Error = NotificationSeverity.Error`

### プログラム呼び出し階層図

```
Roslynコード（言語サービス）
    │
    └─ IOmniSharpNotificationService.SendNotification
           │
           ├─ message: 通知メッセージ
           ├─ title: タイトル（省略可能）
           └─ severity: 重大度
                  │
                  ▼
           OmniSharpホスト実装
                  │
                  ▼
           エディタ（VS Code等）
                  │
                  ▼
           メッセージボックス表示
                  │
                  ▼
           ユーザーがOKクリック
```

### データフロー図

```
[入力]                    [処理]                          [出力]

通知要求            IOmniSharpNotificationService        メッセージボックス
   │                         │
   ├─ message ───▶          │
   ├─ title ─────▶   SendNotification    ───▶   OmniSharpホスト
   └─ severity ──▶          │                         │
                            │                         ▼
                            │                  エディタUI
                            │                         │
                            └──────────────────▶  [OK]ボタン
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOmniSharpNotificationService.cs | `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` | ソース | インターフェース定義 |
| OmniSharpNotificationSeverity.cs | `src/Features/ExternalAccess/OmniSharp/Notification/OmniSharpNotificationSeverity.cs` | ソース | 重大度列挙型 |
| InternalAPI.Unshipped.txt | `src/Features/ExternalAccess/OmniSharp/InternalAPI.Unshipped.txt` | 設定 | 内部API定義 |
