# 通知設計書 18-OmniSharpConfirmMessageBox

## 概要

本ドキュメントは、Roslyn外部アクセス機能における `OmniSharpConfirmMessageBox` 通知サービスの設計仕様を記述する。このメソッドは、OmniSharp統合環境向けにYes/No形式の確認ダイアログを表示し、ユーザーの選択結果を取得するために使用される。

### 本通知の処理概要

OmniSharpConfirmMessageBoxは、IOmniSharpNotificationServiceインターフェースで定義されたメソッドであり、OmniSharpプラットフォーム（Visual Studio Code、Vim、Emacs等のエディタ向け）でユーザーに対して確認ダイアログを表示する。Yes/No形式のメッセージボックスとして表示され、ユーザーの選択結果（true/false）をbool値として返す。

**業務上の目的・背景**：OmniSharpは.NETプロジェクトの言語サービスを提供するサーバーであり、Visual Studio Code等の軽量エディタで使用される。ユーザーの確認が必要な操作（破壊的変更を伴うリファクタリング、ファイルの上書き確認など）を実行する前に、明示的な同意を得るためにこのサービスが使用される。双方向の対話型通知であり、ユーザーのレスポンスを待機する。

**通知の送信タイミング**：Roslynの言語サービスがユーザーの確認を必要とする操作を実行する前に呼び出される。例えば、シンボル名の変更、ファイル移動、破壊的なリファクタリング操作などのシナリオで使用される。

**通知の受信者**：OmniSharpクライアント（VS Code拡張機能等）を通じて、最終的にはエディタを使用している開発者が確認ダイアログを受け取る。

**通知内容の概要**：確認メッセージ本文、オプションのタイトル、および重大度（Information/Warning/Error）。重大度に応じて視覚的な表示が異なる。

**期待されるアクション**：開発者はメッセージを確認し、YesまたはNoをクリックして選択を行う。Yesを選択した場合は操作が続行され、Noを選択した場合は操作がキャンセルされる。

## 通知種別

アプリ内通知（確認ダイアログ形式 - 双方向）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザーレスポンス待機） |
| 優先度 | 重大度に依存（Information/Warning/Error） |
| リトライ | なし |

### 送信先決定ロジック

IOmniSharpNotificationServiceの実装クラスが登録されている場合に、そのインスタンスのConfirmMessageBoxメソッドが呼び出される。OmniSharpホストが実装を提供する。

## 通知テンプレート

### 確認ダイアログの場合

| 項目 | 内容 |
|-----|------|
| 表示形式 | メッセージボックス（Yes/Noボタン付き） |
| タイトル | オプション（省略可能） |
| 重大度 | Information / Warning / Error |
| 戻り値 | bool（true: Yes、false: No） |

### 本文テンプレート

```
{タイトル（省略可能）}

{メッセージ本文}

[Yes]  [No]
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | 確認メッセージ本文 | 呼び出し元 | Yes |
| title | メッセージボックスのタイトル | 呼び出し元 | No |
| severity | メッセージの重大度 | OmniSharpNotificationSeverity | No（デフォルト: Warning） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| リファクタリング | シンボル名変更前 | 破壊的変更の可能性あり | 変更の影響範囲確認 |
| ファイル操作 | ファイル上書き前 | 既存ファイルが存在 | 上書き確認 |
| 設定変更 | 設定リセット前 | ユーザー設定の変更 | リセット確認 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| サービス未登録 | IOmniSharpNotificationServiceの実装が登録されていない場合 |
| ヘッドレスモード | ユーザーインターフェースが利用できない場合 |
| 自動確認モード | 確認をスキップする設定が有効な場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[確認要求発生] --> B{IOmniSharpNotificationService存在?}
    B -->|Yes| C[ConfirmMessageBox呼び出し]
    B -->|No| D[デフォルト動作（false返却等）]
    C --> E[OmniSharpホストに転送]
    E --> F[エディタに確認ダイアログ表示]
    F --> G{ユーザー選択}
    G -->|Yes| H[true返却]
    G -->|No| I[false返却]
    H --> J[操作続行]
    I --> K[操作キャンセル]
    J --> L[終了]
    K --> L
    D --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理）

### 更新テーブル一覧

該当なし（UI表示のみ）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| サービス未登録 | IOmniSharpNotificationServiceがない | false返却またはデフォルト動作 |
| 表示失敗 | エディタ側での表示エラー | ログ記録、false返却 |
| タイムアウト | ユーザー応答なし | 実装依存（通常は待機継続） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（過度な使用は避けるべき） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（ユーザー操作に応じてリアルタイム表示）

## セキュリティ考慮事項

- 確認ダイアログを悪用した操作誘導に注意
- メッセージ内容に機密情報を含めないこと
- 破壊的操作の実行前には必ず確認を取ること
- 外部通信は発生しない

## 備考

- IOmniSharpNotificationServiceはMicrosoft.CodeAnalysis.ExternalAccess.OmniSharp.Notification名前空間で定義
- ConfirmMessageBoxメソッドはbool値を返す同期メソッド
- OmniSharpNotificationSeverityはNotificationSeverity列挙型にマッピング
- デフォルトの重大度はWarning
- titleパラメータはnull許容で、一部の実装では無視される場合がある
- Yes選択時にtrue、No選択時またはダイアログ閉じ時にfalseを返す

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

IOmniSharpNotificationServiceインターフェースと関連する型を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IOmniSharpNotificationService.cs | `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` | ConfirmMessageBoxメソッドの定義（27-30行目） |
| 1-2 | OmniSharpNotificationSeverity.cs | `src/Features/ExternalAccess/OmniSharp/Notification/OmniSharpNotificationSeverity.cs` | 重大度列挙型の定義（9-14行目） |

**読解のコツ**: ConfirmMessageBoxメソッドがboolを返すことに注目。SendNotificationとの違いは戻り値の有無。

#### Step 2: メソッドシグネチャを理解する

ConfirmMessageBoxメソッドの詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IOmniSharpNotificationService.cs | `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` | XMLドキュメントコメント（20-26行目）でメソッドの目的を確認 |

**主要処理フロー**:
1. **22行目**: `message`パラメータ - メッセージボックス内に表示されるメッセージ
2. **23行目**: `title`パラメータ - タイトルバー（一部実装で無視される可能性あり）
3. **24行目**: `severity`パラメータ - メッセージの重大度
4. **25行目**: 戻り値の説明 - Yesでtrue、それ以外でfalse

#### Step 3: SendNotificationとの比較

両メソッドの違いを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IOmniSharpNotificationService.cs | `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` | SendNotification（15-18行目）とConfirmMessageBox（27-30行目）の比較 |

**主要処理フロー**:
- **SendNotification**: void戻り値、OKボタンのみ、一方向通知
- **ConfirmMessageBox**: bool戻り値、Yes/Noボタン、双方向確認

### プログラム呼び出し階層図

```
Roslynコード（言語サービス）
    │
    └─ IOmniSharpNotificationService.ConfirmMessageBox
           │
           ├─ message: 確認メッセージ
           ├─ title: タイトル（省略可能）
           └─ severity: 重大度
                  │
                  ▼
           OmniSharpホスト実装
                  │
                  ▼
           エディタ（VS Code等）
                  │
                  ▼
           確認ダイアログ表示
                  │
                  ├─▶ Yes クリック → true 返却
                  │
                  └─▶ No クリック → false 返却
                            │
                            ▼
                     操作続行/キャンセル判断
```

### データフロー図

```
[入力]                    [処理]                          [出力]

確認要求            IOmniSharpNotificationService        確認ダイアログ
   │                         │
   ├─ message ───▶          │
   ├─ title ─────▶  ConfirmMessageBox   ───▶   OmniSharpホスト
   └─ severity ──▶          │                         │
                            │                         ▼
                            │                  エディタUI
                            │                         │
                            ◀──── bool ────────  [Yes] [No]
                            │
                            ▼
                   true: 操作続行
                   false: 操作キャンセル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IOmniSharpNotificationService.cs | `src/Features/ExternalAccess/OmniSharp/Notification/IOmniSharpNotificationService.cs` | ソース | インターフェース定義 |
| OmniSharpNotificationSeverity.cs | `src/Features/ExternalAccess/OmniSharp/Notification/OmniSharpNotificationSeverity.cs` | ソース | 重大度列挙型 |
| InternalAPI.Unshipped.txt | `src/Features/ExternalAccess/OmniSharp/InternalAPI.Unshipped.txt` | 設定 | 内部API定義 |
