# 通知設計書 2-ConfirmMessageBox

## 概要

本ドキュメントは、Roslynプロジェクトにおける`ConfirmMessageBox`通知メソッドの設計仕様を記載するものである。このメソッドは、Visual Studioエディタ環境においてユーザーに対してYes/No形式の確認ダイアログを表示し、ユーザーの選択結果を取得する機能を提供する。

### 本通知の処理概要

`ConfirmMessageBox`は、`INotificationService`インターフェースで定義されたメソッドであり、Yes/No形式の確認ダイアログを表示してユーザーの選択結果（true/false）を返す機能を提供する。`SendNotification`と同様にInformation、Warning、Errorの3種類の重大度をサポートするが、ユーザーからの応答（Yes/No）を取得する点が異なる。

**業務上の目的・背景**：開発者がコードを編集・リファクタリングする際に、重要な操作の実行前にユーザーの確認を得る必要がある場合がある。例えば、破壊的な変更を伴う操作、複数ファイルへの影響がある操作、元に戻せない操作などでは、ユーザーの明示的な同意を得ることで誤操作を防止し、開発者の意図に沿った操作のみを実行する。これにより、予期しない変更からコードベースを保護する。

**通知の送信タイミング**：ユーザーの確認が必要なリファクタリング操作時、型生成時のオプション選択時、名前変更操作時など、ユーザーの判断を仰ぐ必要がある場面で同期的に送信される。具体的には、ExtractMethod実行時の確認、GenerateType操作時、InlineRename完了時などで使用される。

**通知の受信者**：Visual StudioまたはWPFエディタを使用している開発者。通知は現在アクティブなIDEウィンドウに対してモーダルダイアログとして表示される。

**通知内容の概要**：ユーザーに確認を求めるメッセージテキスト、オプションのタイトル、重大度に応じたアイコンがメッセージボックスとして表示される。Yes/Noの2つのボタンが提供される。

**期待されるアクション**：ユーザーはメッセージを読み、操作を続行する場合はYesボタンを、キャンセルする場合はNoボタンをクリックする。この選択結果が呼び出し元に返され、後続の処理フローが決定される。

## 通知種別

アプリ内通知（モーダル確認ダイアログ）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ユーザー応答を待機） |
| 優先度 | 高（モーダルダイアログとして表示） |
| リトライ | 無し（ユーザー入力待機のため） |

### 送信先決定ロジック

通知は常に現在のIDEインスタンスのアクティブウィンドウに対して表示される。特定のユーザーロールやプロジェクト設定による受信者のフィルタリングは行われない。

## 通知テンプレート

### メッセージボックス通知

| 項目 | 内容 |
|-----|------|
| ダイアログタイプ | モーダルメッセージボックス |
| ボタン構成 | Yes / No |
| アイコン | 重大度に応じて変化（Info/Warning/Error） |

### 本文テンプレート

```
{message}
```

メッセージ内容は呼び出し元が動的に決定する。タイトルはオプションで、指定されない場合はシステムデフォルトまたは非表示。

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | - | - | メッセージボックス通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| message | 確認を求めるメッセージ本文 | 呼び出し元から直接渡される | Yes |
| title | ダイアログのタイトル | 呼び出し元から直接渡される | No |
| severity | 通知の重大度 | NotificationSeverity列挙型 | No（デフォルト: Warning） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 画面操作 | ExtractMethod実行 | ユーザー確認が必要な場合 | 抽出操作の確認 |
| 画面操作 | ChangeSignature実行 | 破壊的変更を伴う場合 | シグネチャ変更の確認 |
| 画面操作 | GenerateType実行 | 型生成オプションの確認時 | 型生成の確認 |
| 画面操作 | RenameTracking完了 | 名前変更の適用確認時 | リネーム適用の確認 |
| 画面操作 | EncapsulateField実行 | フィールドカプセル化の確認時 | カプセル化の確認 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| NotificationCallbackが設定されている場合 | テスト環境でコールバックが設定されている場合、実際のメッセージボックスは表示されずコールバックが呼ばれ、常にtrueを返す |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[呼び出し元がConfirmMessageBoxを呼び出し] --> B{NotificationCallbackが設定されているか?}
    B -->|Yes| C[コールバックを実行]
    C --> D[trueを返す]
    B -->|No| E[UIモードをモーダルに設定]
    E --> F[SeverityをアイコンにマッピNG]
    F --> G[ShowMessageBox YESNO を呼び出し]
    G --> H{ユーザーの選択}
    H -->|Yes| I[trueを返す]
    H -->|No| J[falseを返す]
    I --> K[UIモードを非モーダルに復元]
    J --> K
    D --> L[終了]
    K --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | データベースアクセスなし（純粋なUI操作） |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | データベースへの更新なし |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| UIシェル例外 | IVsUIShellサービスが利用できない場合 | finallyブロックでモーダル状態を解除し、UIがロックされることを防止 |
| パラメータ不正 | messageがnullの場合 | 呼び出し元で事前チェックが必要 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（ユーザー操作起点のため） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

ユーザー操作に応じて即座に送信されるため、時間帯制限なし。

## セキュリティ考慮事項

- メッセージ内容にユーザーの入力値を含める場合、XSS対策は不要（ネイティブUI使用のため）
- 機密情報をメッセージに含めないよう呼び出し元で注意が必要
- テスト環境でのコールバック機能はプロダクション環境では使用しないこと
- Yes/Noの選択が重要な操作に影響するため、メッセージは明確で誤解のない表現にすること

## 備考

- Visual Studio環境では`VSNotificationServiceFactory.VSDialogService`が実装を提供
- エディタ環境（WPF）では`EditorNotificationServiceFactory.EditorDialogService`が実装を提供
- テスト環境ではコールバック使用時に常にtrueが返されるため、Noの選択をテストする場合は別途考慮が必要
- ダイアログ結果は整数値6がYesを示す（VS環境固有の実装詳細）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知に関連するインターフェースと列挙型の定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | INotificationService.cs | `src/Features/Core/Portable/Notification/INotificationService.cs` | INotificationServiceインターフェースの定義、ConfirmMessageBoxメソッドの契約（行24-34）を理解する |
| 1-2 | INotificationServiceCallback.cs | `src/Features/Core/Portable/Notification/INotificationServiceCallback.cs` | テスト用コールバックインターフェースの構造を理解する |

**読解のコツ**: `ConfirmMessageBox`の戻り値が`bool`であり、Yesクリック時にtrue、それ以外でfalseを返すことに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となる実装クラスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VSNotificationServiceFactory.cs | `src/VisualStudio/Core/Def/Notification/VSNotificationServiceFactory.cs` | Visual Studio環境での実装（行90-117）。OLEMSGBUTTON.OLEMSGBUTTON_YESNOを使用 |
| 2-2 | EditorNotificationServiceFactory.cs | `src/EditorFeatures/Core/Notification/EditorNotificationServiceFactory.cs` | WPFエディタ環境での実装（行65-81）。MessageBoxButton.YesNoを使用 |

**主要処理フロー**:
1. **行90-117（VSDialogService.ConfirmMessageBox）**: UIモードをモーダルに設定し、Yes/Noボタン付きのShowMessageBoxを呼び出し
2. **行110**: dialogResult == 6 がYesクリックを示す

#### Step 3: 呼び出し元を理解する

実際にConfirmMessageBoxを呼び出しているコマンドハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExtractMethodCommandHandler.cs | `src/EditorFeatures/Core/ExtractMethod/ExtractMethodCommandHandler.cs` | メソッド抽出時の確認ダイアログ使用例 |
| 3-2 | AbstractChangeSignatureCommandHandler.cs | `src/EditorFeatures/Core/ChangeSignature/AbstractChangeSignatureCommandHandler.cs` | シグネチャ変更時の確認使用例 |
| 3-3 | ChangeSignatureCodeActionOperation.cs | `src/Features/Core/Portable/ChangeSignature/ChangeSignatureCodeActionOperation.cs` | コードアクション実行時の確認使用例 |

### プログラム呼び出し階層図

```
呼び出し元コマンドハンドラ
    │
    ├─ INotificationService.ConfirmMessageBox()
    │      │
    │      ├─ VSDialogService (Visual Studio)
    │      │      ├─ NotificationCallback?.Invoke() → return true [テスト時]
    │      │      └─ IVsUIShell.ShowMessageBox(YESNO) → return result==6 [プロダクション]
    │      │
    │      └─ EditorDialogService (WPF Editor)
    │             ├─ NotificationCallback?.Invoke() → return true [テスト時]
    │             └─ MessageBox.Show(YesNo) → return result==Yes [プロダクション]
    │
    └─ 呼び出し元が戻り値(bool)に基づいて処理を分岐
```

### データフロー図

```
[入力]                      [処理]                           [出力]

message: string ───────┐
                       │
title: string? ────────┼──▶ INotificationService ──▶ 確認ダイアログ表示
                       │        │                          │
severity: enum ────────┘        │                          ▼
                                ▼                    ユーザー選択
                         ConfirmMessageBox               │
                                │                        │
                                ◀────────────────────────┘
                                │
                                ▼
                          bool (true/false)
                                │
                                ▼
                          呼び出し元へ返却
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| INotificationService.cs | `src/Features/Core/Portable/Notification/INotificationService.cs` | インターフェース | 通知サービスの契約定義 |
| INotificationServiceCallback.cs | `src/Features/Core/Portable/Notification/INotificationServiceCallback.cs` | インターフェース | テスト用コールバック契約 |
| VSNotificationServiceFactory.cs | `src/VisualStudio/Core/Def/Notification/VSNotificationServiceFactory.cs` | ソース | Visual Studio環境の実装 |
| EditorNotificationServiceFactory.cs | `src/EditorFeatures/Core/Notification/EditorNotificationServiceFactory.cs` | ソース | エディタ環境の実装 |
| ExtractMethodCommandHandler.cs | `src/EditorFeatures/Core/ExtractMethod/ExtractMethodCommandHandler.cs` | ソース | 使用例（ExtractMethod） |
| ChangeSignatureCodeActionOperation.cs | `src/Features/Core/Portable/ChangeSignature/ChangeSignatureCodeActionOperation.cs` | ソース | 使用例（ChangeSignature） |
| TestNotificationService.vb | `src/EditorFeatures/TestUtilities2/Utilities/TestNotificationService.vb` | テスト | テスト用のモック実装 |
