# 通知設計書 5-DidChangeConfiguration

## 概要

本ドキュメントは、Roslynプロジェクトにおける`DidChangeConfiguration`LSP標準通知の設計仕様を記載するものである。この通知は、Language Server Protocol（LSP）の標準仕様に定義された`workspace/didChangeConfiguration`通知であり、クライアント側の設定変更時にサーバーへ通知するためのメカニズムを提供する。

### 本通知の処理概要

`DidChangeConfiguration`は、LSP標準の`workspace/didChangeConfiguration`メソッドとして定義された通知であり、クライアント（エディタ）の設定が変更された際にLanguage Serverへ通知を送信する。Roslynでは`DidChangeConfigurationNotificationHandler`がこの通知を処理し、C#およびVisual Basicのオプション値を同期する。

**業務上の目的・背景**：IDEやエディタの設定をLanguage Serverと同期することで、ユーザーがエディタ側で変更した設定（例：コードスタイル設定、型メンバーの挿入位置など）がLanguage Serverの動作に即座に反映される。これにより、ユーザーは設定変更後に再起動することなく、新しい設定に基づいた機能（コード補完、診断、リファクタリング提案など）を利用できる。設定の一貫性を保つことで、開発体験の向上とユーザーの期待通りの動作を実現する。

**通知の送信タイミング**：クライアント（エディタ）側で設定が変更された時点で送信される。Visual Studio CodeやVisual Studioなどのエディタが設定変更を検知し、自動的にLanguage Serverへ通知を送信する。

**通知の受信者**：Roslyn Language Server。通知を受信したサーバーは、クライアントから最新の設定値を取得し、内部のグローバルオプションを更新する。

**通知内容の概要**：`DidChangeConfigurationParams`として設定変更の情報が送信される。ただし、Roslynの実装では通知パラメータの内容は直接使用せず、通知をトリガーとして`workspace/configuration`リクエストを発行し、最新の設定値を取得する。

**期待されるアクション**：Language Serverは設定変更通知を受信後、クライアントから最新の設定値を取得し、内部オプションを更新する。また、`IOnConfigurationChanged`インターフェースを実装するサービスに設定変更を通知する。

## 通知種別

LSP標準通知（workspace/didChangeConfiguration）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（クライアントからサーバーへの通知） |
| 優先度 | 中（設定同期のため） |
| リトライ | 無し（通知は送信のみ） |

### 送信先決定ロジック

クライアントからLanguage Serverへの通知であるため、送信先はLanguage Server自体。サーバーは受信した通知に基づいて内部処理を実行する。

## 通知テンプレート

### LSP通知パラメータ

| 項目 | 内容 |
|-----|------|
| メソッド名 | `workspace/didChangeConfiguration` |
| パラメータ形式 | LSP.DidChangeConfigurationParams |

### 設定セクション形式

```
{言語プレフィックス}|{オプショングループ}.{オプション名}
```

例：
- `csharp|implement_type.dotnet_member_insertion_location`
- `visual_basic|implement_type.dotnet_member_insertion_location`

### サポート言語プレフィックス

| 言語 | プレフィックス |
|-----|--------------|
| C# | `csharp` |
| Visual Basic | `visual_basic` |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| settings | 設定オブジェクト（未使用） | クライアントから渡される | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 設定変更 | エディタ設定変更 | 設定が変更された場合 | ユーザーがエディタの設定を変更 |
| 初期化 | クライアント初期化完了 | サーバー初期化後 | IOnInitializedによる初期設定取得 |
| 設定ファイル変更 | .editorconfig等の変更 | ファイル保存時 | 設定ファイルの内容が変更された場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| workspace/configurationをサポートしない場合 | クライアントがこの機能をサポートしない場合は設定取得をスキップ |

## 処理フロー

### 受信フロー

```mermaid
flowchart TD
    A[クライアントがworkspace/didChangeConfigurationを送信] --> B[DidChangeConfigurationNotificationHandlerが受信]
    B --> C[RefreshOptionsAsyncを呼び出し]
    C --> D{workspace/configurationをサポート?}
    D -->|No| E[処理終了]
    D -->|Yes| F[workspace/configurationリクエストを送信]
    F --> G[クライアントから設定値を取得]
    G --> H[各設定値をパース]
    H --> I[GlobalOptionServiceを更新]
    I --> J[IOnConfigurationChangedを通知]
    J --> K[終了]
    E --> K
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | - | データベースアクセスなし |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | - | インメモリのGlobalOptionServiceを更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 設定値パース失敗 | 設定値が期待した型に変換できない場合 | 警告ログを出力し、該当オプションの更新をスキップ |
| workspace/configuration失敗 | クライアントからのレスポンスがnull | Contract.ThrowIfNullで例外 |
| クライアント未サポート | workspace/configurationをサポートしない | 設定取得をスキップ（正常終了） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（設定変更頻度に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

設定変更に応じて即座に送信されるため、時間帯制限なし。

## セキュリティ考慮事項

- 設定値はユーザーが意図的に設定したものであり、信頼される
- workspace/configurationリクエストはLSP標準に準拠しており、安全な通信が保証される
- 設定値のパースエラーは適切にログ記録され、システムの安定性に影響しない

## 備考

- LSP標準の`workspace/didChangeConfiguration`に準拠
- `IOnInitialized`インターフェースを実装し、サーバー初期化時にも設定を取得
- `IOnConfigurationChanged`インターフェースを通じて設定変更を他のサービスに通知
- サポートされるオプションは`SupportedOptions`静的プロパティで定義
- C#とVisual Basicの両言語に対応（`IPerLanguageValuedOption`の場合）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、LSP標準のパラメータ型と設定項目の構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DidChangeConfigurationParams.cs | `src/LanguageServer/Protocol/Protocol/DidChangeConfigurationParams.cs` | LSP標準のパラメータ構造を理解する |
| 1-2 | DidChangeConfigurationNotificationHandler_OptionList.cs | `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler_OptionList.cs` | サポートされるオプションのリストを理解する |

**読解のコツ**: `SupportedOptions`配列に定義されたオプションがworkspace/configurationで取得対象となることに注目。

#### Step 2: エントリーポイントを理解する

通知ハンドラの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DidChangeConfigurationNotificationHandler.cs | `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler.cs` | メインのハンドラ実装。HandleNotificationAsync（行66-75）とRefreshOptionsAsync（行77-118）を理解する |

**主要処理フロー**:
1. **行66-75（HandleNotificationAsync）**: RefreshOptionsAsyncを呼び出し、その後IOnConfigurationChangedを通知
2. **行77-118（RefreshOptionsAsync）**: workspace/configurationをサポートする場合のみ設定を取得・更新
3. **行98-117**: 取得した設定値をパースしてGlobalOptionServiceを更新

#### Step 3: 初期化時の設定取得を理解する

IOnInitializedインターフェースの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DidChangeConfigurationNotificationHandler_OnInitialized.cs | `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler_OnInitialized.cs` | サーバー初期化時の設定取得とダイナミック登録を理解する |

#### Step 4: オプション生成ロジックを理解する

設定セクション名の生成方法を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DidChangeConfigurationNotificationHandler.cs | `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler.cs` | GenerateFullNameForOption（行195-201）とGenerateOptionGroupName（行204-228）を理解する |

### プログラム呼び出し階層図

```
クライアント（エディタ）
    │
    └─ workspace/didChangeConfiguration 送信
           │
           ▼
DidChangeConfigurationNotificationHandler.HandleNotificationAsync()
    │
    ├─ RefreshOptionsAsync()
    │      │
    │      ├─ GetConfigurationsAsync()
    │      │      │
    │      │      └─ IClientLanguageServerManager.SendRequestAsync()
    │      │             │
    │      │             └─ workspace/configuration リクエスト
    │      │
    │      └─ IGlobalOptionService.SetGlobalOptions()
    │
    └─ IOnConfigurationChanged.OnConfigurationChangedAsync()
           │
           └─ 各サービスへ設定変更を通知
```

### データフロー図

```
[入力]                          [処理]                              [出力]

クライアント設定変更
        │
        ▼
workspace/didChangeConfiguration
        │
        ▼
DidChangeConfigurationNotificationHandler
        │
        ├──▶ workspace/configuration リクエスト
        │           │
        │           ▼
        │    クライアントから設定値取得
        │           │
        │           ▼
        └──▶ 設定値パース・検証
                    │
                    ▼
             IGlobalOptionService.SetGlobalOptions()
                    │
                    ▼
             IOnConfigurationChanged通知
                    │
                    ▼
             各サービスの動作に反映
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DidChangeConfigurationNotificationHandler.cs | `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler.cs` | ソース | メイン通知ハンドラ |
| DidChangeConfigurationNotificationHandler_OnInitialized.cs | `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler_OnInitialized.cs` | ソース | 初期化時処理 |
| DidChangeConfigurationNotificationHandler_OptionList.cs | `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandler_OptionList.cs` | ソース | サポートオプションリスト |
| DidChangeConfigurationNotificationHandlerFactory.cs | `src/LanguageServer/Protocol/Handler/Configuration/DidChangeConfigurationNotificationHandlerFactory.cs` | ソース | ハンドラファクトリ |
| DidChangeConfigurationParams.cs | `src/LanguageServer/Protocol/Protocol/DidChangeConfigurationParams.cs` | ソース | LSPパラメータ型 |
| DidChangeConfigurationClientCapabilities.cs | `src/LanguageServer/Protocol/Protocol/DidChangeConfigurationClientCapabilities.cs` | ソース | クライアント機能定義 |
| Methods.Workspace.cs | `src/LanguageServer/Protocol/Protocol/Methods.Workspace.cs` | ソース | LSPメソッド名定義 |
| DidChangeConfigurationNotificationHandlerTest.cs | `src/LanguageServer/ProtocolUnitTests/Configuration/DidChangeConfigurationNotificationHandlerTest.cs` | テスト | ハンドラのユニットテスト |
