---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：1-SendNotification

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **レート制限の設定値**：コード上で制限なしと推測したが明示的な根拠なし
  2. **セキュリティ考慮事項**：一般的なガイドラインとして記載、プロジェクト固有の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Features/Core/Portable/Notification/INotificationService.cs` - インターフェース定義
- E-02: `src/VisualStudio/Core/Def/Notification/VSNotificationServiceFactory.cs` - VS環境実装
- E-03: `src/EditorFeatures/Core/Notification/EditorNotificationServiceFactory.cs` - エディタ環境実装
- E-04: `src/EditorFeatures/Core/GoToDefinition/GoToDefinitionCommandHandler.cs` - 呼び出し元例
- E-05: `src/EditorFeatures/Core/ExtractMethod/ExtractMethodCommandHandler.cs` - 呼び出し元例
- E-06: `src/EditorFeatures/Core/ChangeSignature/AbstractChangeSignatureCommandHandler.cs` - 呼び出し元例
- E-07: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INotificationServiceインターフェースで定義されている | E-01 | ○ |
| C-02 | OKボタン付きメッセージボックスを表示する | E-01 行19-22 | ○ |
| C-03 | Information、Warning、Errorの3種類の重大度をサポート | E-01 行22 (NotificationSeverity) | ○ |
| C-04 | Visual Studioではモーダルダイアログとして表示 | E-02 行65-86 | ○ |
| C-05 | WPFエディタではMessageBox.Showを使用 | E-03 行61 | ○ |
| C-06 | NotificationCallbackでテスト用コールバックをサポート | E-02 行48, E-03 行45 | ○ |
| C-07 | UIモードをモーダル/非モーダルに切り替える | E-02 行65, 85 | ○ |
| C-08 | SeverityをOLEMSGICONにマッピングする（VS環境） | E-02 行119-137 | ○ |
| C-09 | SeverityをMessageBoxImageにマッピングする（Editor環境） | E-03 行84-90 | ○ |
| C-10 | 同期的に送信される | E-01, E-02, E-03 戻り値void | ○ |
| C-11 | GoToDefinition失敗時に使用される | E-04 | ○ |
| C-12 | ExtractMethod失敗時に使用される | E-05 | ○ |
| C-13 | ChangeSignature操作時に使用される | E-06 | ○ |
| C-14 | finallyブロックでモーダル状態を解除する | E-02 行83-86 | ○ |
| C-15 | titleパラメータはオプション | E-01 行17 (= null) | ○ |
| C-16 | severityのデフォルトはWarning | E-01 行22 | ○ |
| C-17 | レート制限は設定されていない | **根拠なし** | △ |
| C-18 | セキュリティ考慮事項（XSS不要など） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レート制限に関するコード上の明示的な設定がないため、「制限なし」と推測した
  - 候補：設計ドキュメント / 要件定義書 / コメント内の記述
- セキュリティガイドラインはプロジェクト固有のものが見つからない
  - 候補：SECURITY.md / 開発ガイドライン / コードレビュー基準

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェース定義とソースコードから確認可能な主張が大半
- 1: 中リスク - レート制限・セキュリティ考慮事項は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] INotificationServiceインターフェースの定義が最新のコードと一致しているか
- [ ] VSDialogServiceとEditorDialogServiceの実装詳細が正確か
- [ ] 記載されたトリガー（GoToDefinition等）が網羅的か
- [ ] テストコールバック機能の記述がテストコードと一致しているか
