---
generated_at: 2026-02-10 11:02:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-NotificationOption2.None

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` - 構造体定義
- E-02: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/CodeStyleOption2`1.cs` - コードスタイルオプション
- E-03: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/CodeStyleHelpers.cs` - パースヘルパー
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` - 通知一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NotificationOption2.None静的プロパティが存在 | E-01 行21 | ○ |
| C-02 | ReportDiagnostic.Suppressにマッピング | E-01 行21 | ○ |
| C-03 | IsExplicitlySpecifiedがfalse | E-01 行21 | ○ |
| C-04 | record structとして定義 | E-01 行15-16 | ○ |
| C-05 | DataContract属性が付与 | E-01 行14 | ○ |
| C-06 | Silentは ReportDiagnostic.Hidden | E-01 行26 | ○ |
| C-07 | SuggestionはReportDiagnostic.Info | E-01 行31 | ○ |
| C-08 | WarningはReportDiagnostic.Warn | E-01 行36 | ○ |
| C-09 | ErrorはReportDiagnostic.Error | E-01 行41 | ○ |
| C-10 | ForSeverityメソッドでReportDiagnosticから変換 | E-01 行46-55 | ○ |
| C-11 | ForSeverityメソッドでDiagnosticSeverityから変換 | E-01 行57-65 | ○ |
| C-12 | WithIsExplicitlySpecifiedメソッドが存在 | E-01 行43-44 | ○ |
| C-13 | 予期しない値でExceptionUtilities.UnexpectedValue | E-01 行54, 64 | ○ |
| C-14 | 5段階の通知レベル（None, Silent, Suggestion, Warning, Error） | E-01 行21, 26, 31, 36, 41 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] NotificationOption2構造体の定義が最新のコードと一致しているか
- [ ] 5段階の通知レベルとReportDiagnosticのマッピングが正確か
- [ ] ForSeverityメソッドの変換ロジックが正しいか
- [ ] .editorconfigでの設定形式が正確に記載されているか
