---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-NotificationOption2.Error

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` 38-41行目
- E-02: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` 41行目
- E-03: `src/Analyzers/Core/Analyzers/Helpers/DiagnosticHelper.cs` 268行目
- E-04: `src/Analyzers/Core/Analyzers/Helpers/DiagnosticHelper.cs` 276行目
- E-05: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` 20行目
- E-06: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` 48行目
- E-07: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/CodeStyle/NotificationOption2.cs` 60行目
- E-08: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/ReportDiagnosticExtensions.cs` 30行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ErrorはReportDiagnostic.Errorにマッピングされる | E-02 | ○ |
| C-02 | XMLドキュメントで「error option」と説明 | E-01 | ○ |
| C-03 | DiagnosticHelper.CreateでSeverityが使用される | E-03 | ○ |
| C-04 | warningLevelが0に設定される（エラーの場合） | E-04 | ○ |
| C-05 | EditorConfig文字列表現は「error」 | E-05 | ○ |
| C-06 | ForSeverityでError→Errorの変換 | E-06 | ○ |
| C-07 | DiagnosticSeverity.Errorからの変換 | E-07 | ○ |
| C-08 | ToNotificationOptionでの変換 | E-08 | ○ |
| C-09 | 診断はエディタ上で赤色波線として表示される | IDE標準動作 | ○ |
| C-10 | ビルドはエラーとして失敗する | コンパイラ標準動作 | ○ |
| C-11 | Severityプロパティでの重大度取得 | E-02 | ○ |
| C-12 | IsExplicitlySpecifiedプロパティの存在 | E-02 | ○ |
| C-13 | record structとしての定義 | E-01 | ○ |
| C-14 | エラーカウントが増加する | IDE標準動作 | ○ |
| C-15 | #pragma warning disableで抑制可能 | 言語仕様 | ○ |
| C-16 | 最も厳格なコードスタイル強制レベル | 設計意図 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての技術的記述がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] Error診断の赤色波線表示をIDEで確認
- [ ] EditorConfig設定（error）との連携動作を検証
- [ ] エラーリストでの「エラー」表示とエラーカウントを確認
- [ ] ビルド失敗の動作を確認
- [ ] CI/CDパイプラインでのビルドブロック動作を確認
