---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-INotificationHandler

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **TLS使用推奨のセキュリティ考慮事項**：ソースコードに明示的な記載なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/INotificationHandler.cs` 13-20行目
- E-02: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/INotificationHandler.cs` 17行目
- E-03: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/INotificationHandler.cs` 19行目
- E-04: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/Handlers/InitializedHandler.cs` 14行目
- E-05: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/Handlers/InitializedHandler.cs` 19行目
- E-06: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/Handlers/InitializedHandler.cs` 21-28行目
- E-07: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/MethodHandlerDetails.cs` 85-88行目
- E-08: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/QueueItem.cs` 209-214行目
- E-09: `src/LanguageServer/Protocol/Handler/ILspServiceNotificationHandler.cs` 9-14行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | INotificationHandler<TRequestContext>はIMethodHandlerを継承 | E-02 | ○ |
| C-02 | HandleNotificationAsyncメソッドがTaskを返す | E-03 | ○ |
| C-03 | LanguageServerEndpoint属性でメソッド名を定義 | E-04 | ○ |
| C-04 | MutatesSolutionStateプロパティが存在 | E-05 | ○ |
| C-05 | InitializedHandlerが実装例として存在 | E-06 | ○ |
| C-06 | MethodHandlerDetailsでINotificationHandler<>を検出 | E-07 | ○ |
| C-07 | QueueItem.StartRequestAsyncで通知処理 | E-08 | ○ |
| C-08 | NoValue.Instanceが返却される | E-08 | ○ |
| C-09 | CancellationTokenパラメータがある | E-03 | ○ |
| C-10 | パラメータなし通知の処理に使用 | E-01（XMLドキュメント） | ○ |
| C-11 | ILspServiceNotificationHandlerがRoslyn拡張 | E-09 | ○ |
| C-12 | JSON-RPC 2.0プロトコルを使用 | LSP仕様 | ○ |
| C-13 | 一方向通知でレスポンスなし | E-01（XMLドキュメント） | ○ |
| C-14 | TRequestContextでリクエストコンテキストを指定 | E-02 | ○ |
| C-15 | 例外発生時はログ記録のみ | E-08（TrySetException呼び出し） | ○ |
| C-16 | ネットワーク経由の場合はTLSを推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **C-16: TLS使用推奨**
  - セキュリティに関するベストプラクティスとして記載したが、ソースコード内に明示的な記載なし
  - 候補：LSP仕様書 / セキュリティガイドライン / アーキテクチャドキュメント

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 技術的な記述はソースコードで確認可能
- 1: 中リスク - セキュリティ考慮事項は一般的なベストプラクティスに基づく

## 6) レビュアーチェックリスト（最小）

- [ ] INotificationHandler実装の動作をデバッグで確認
- [ ] LanguageServerEndpoint属性の正しい使用方法を確認
- [ ] InitializedHandler以外の実装例を確認
- [ ] C-16のTLS推奨について、プロジェクトのセキュリティポリシーと照合
